/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.CaptionStyleCompat;
import com.google.android.exoplayer2.ui.PlaybackControlView;
import com.google.android.exoplayer2.ui.SimpleExoPlayerView;
import com.sambatech.player.CustomTimeBar;
import com.sambatech.player.PlayPauseState;
import com.sambatech.player.R;
import com.sambatech.player.adapter.CaptionsSheetAdapter;
import com.sambatech.player.adapter.OutputSheetAdapter;
import com.sambatech.player.adapter.SpeedSheetAdapter;
import com.sambatech.player.cast.CastOptionsMenu;
import com.sambatech.player.cast.CastPlayer;
import com.sambatech.player.mediasource.PlayerMediaSourceInterface;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.utils.OptionsMenuLayer;
import com.sambatech.player.utils.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class SambaSimplePlayerView
implements View.OnClickListener {
    private Context context;
    private FrameLayout playerContainer;
    private SimpleExoPlayer player;
    private SimpleExoPlayerView playerView;
    private OptionsMenuLayer optionsMenuLayer;
    private FrameLayout loadingView;
    private LinearLayout progressControls;
    private ImageButton fullscreenButton;
    private LinearLayout bottomBar;
    private LinearLayout controlsView;
    private LinearLayout topBar;
    private ImageButton optionsMenuButton;
    private ImageButton liveButton;
    private FrameLayout castButton;
    private TextView videoTitle;
    private boolean isFullscreen = false;
    private boolean isReverseLandscape = false;
    private boolean isLive = false;
    private boolean isVideo = false;
    private boolean hasCast = false;
    private boolean isDVR = false;
    private View outputSheetView;
    private View captionSheetView;
    private View speedSheetView;
    private CustomTimeBar customTimeBar;
    private ProgressBar progressBar;
    private LinearLayout smallPlayPauseContainer;
    private ImageButton playSmallButton;
    private ImageButton pauseSmallButton;
    private ProgressBar smallProgressBar;
    private HashMap<String, View> controlsMap;
    private LinkedHashSet<View> hiddenViews;
    private boolean hasMenu = false;
    private PlaybackControlView castControlView;
    private CastPlayer sambaCastPlayer;
    private CastOptionsMenu castOptionsMenu;
    private BottomSheetDialog outputSheetDialog;
    private BottomSheetDialog captionsSheetDialog;
    private BottomSheetDialog speedSheetDialog;
    private boolean menuWasPlaying;
    private View.OnClickListener playPauseClickLisner = new View.OnClickListener(){

        public void onClick(View v) {
            int i = v.getId();
            if (i == R.id.small_play) {
                SambaSimplePlayerView.this.player.setPlayWhenReady(true);
            } else if (i == R.id.small_pause) {
                SambaSimplePlayerView.this.player.setPlayWhenReady(false);
            }
        }
    };
    private OptionsMenuLayer.OptionsMenuCallback optionsMenuCallBack = new OptionsMenuLayer.OptionsMenuCallback(){

        @Override
        public void onTouchHD() {
            if (SambaSimplePlayerView.this.outputSheetDialog == null) {
                return;
            }
            SambaSimplePlayerView.this.outputSheetDialog.show();
        }

        @Override
        public void onTouchCaptions() {
            if (SambaSimplePlayerView.this.captionsSheetDialog == null) {
                return;
            }
            SambaSimplePlayerView.this.captionsSheetDialog.show();
        }

        @Override
        public void onTouchSpeed() {
            if (SambaSimplePlayerView.this.speedSheetDialog == null) {
                return;
            }
            SambaSimplePlayerView.this.speedSheetDialog.show();
        }

        @Override
        public void onMenuDismiss() {
            if (SambaSimplePlayerView.this.menuWasPlaying) {
                SambaSimplePlayerView.this.player.setPlayWhenReady(true);
                SambaSimplePlayerView.this.playerView.hideController();
            } else {
                SambaSimplePlayerView.this.playerView.showController();
            }
            if (SambaSimplePlayerView.this.isFullscreen) {
                ((Activity)SambaSimplePlayerView.this.context).getWindow().getDecorView().setSystemUiVisibility(5638);
            }
        }
    };
    private final int mFullScreenFlags = 5638;
    private ViewGroup.LayoutParams originalContainerLayoutParams;
    private FullscreenCallback fullscreenCallback;

    public SambaSimplePlayerView(Context context, FrameLayout playerContainer) {
        this.context = context;
        this.playerContainer = playerContainer;
        this.playerView = (SimpleExoPlayerView)SimpleExoPlayerView.inflate((Context)context, (int)R.layout.custom_simple_exo_player_view, null);
        this.bindMethods();
        this.createMenuView();
        this.originalContainerLayoutParams = this.playerContainer.getLayoutParams();
        this.playerContainer.addView((View)this.playerView, new ViewGroup.LayoutParams(-1, -1));
        this.playerContainer.setBackgroundColor(-16777216);
        this.playerView.setBackgroundColor(-16777216);
        this.initControlsMap();
    }

    public void bindMethods() {
        this.videoTitle = (TextView)this.playerView.findViewById(R.id.video_title_text);
        this.optionsMenuButton = (ImageButton)this.playerView.findViewById(R.id.topbar_menu_button);
        this.liveButton = (ImageButton)this.playerView.findViewById(R.id.topbar_live_button);
        this.castButton = (FrameLayout)this.playerView.findViewById(R.id.topbar_cast_button);
        this.fullscreenButton = (ImageButton)this.playerView.findViewById(R.id.fullscreen_button);
        this.loadingView = (FrameLayout)this.playerView.findViewById(R.id.exo_progress_view);
        this.controlsView = (LinearLayout)this.playerView.findViewById(R.id.exo_control_bar);
        this.topBar = (LinearLayout)this.playerView.findViewById(R.id.exo_top_bar);
        this.bottomBar = (LinearLayout)this.playerView.findViewById(R.id.exo_bottom_bar);
        this.progressControls = (LinearLayout)this.playerView.findViewById(R.id.exo_progress_controls);
        this.customTimeBar = (CustomTimeBar)this.playerView.findViewById(R.id.exo_progress);
        this.progressBar = (ProgressBar)this.playerView.findViewById(R.id.progress_bar);
        this.playSmallButton = (ImageButton)this.playerView.findViewById(R.id.small_play);
        this.pauseSmallButton = (ImageButton)this.playerView.findViewById(R.id.small_pause);
        this.smallPlayPauseContainer = (LinearLayout)this.playerView.findViewById(R.id.play_pause_container);
        this.smallProgressBar = (ProgressBar)this.playerView.findViewById(R.id.small_progress);
        this.fullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.optionsMenuButton.setOnClickListener((View.OnClickListener)this);
        this.liveButton.setOnClickListener((View.OnClickListener)this);
        this.playerView.findViewById(R.id.cast_image_container).setOnClickListener((View.OnClickListener)this);
        this.playSmallButton.setOnClickListener(this.playPauseClickLisner);
        this.pauseSmallButton.setOnClickListener(this.playPauseClickLisner);
    }

    public void createMenuView() {
        View menuPlaceholder = this.playerView.findViewById(R.id.exo_menu_placeholder);
        ViewGroup parent = (ViewGroup)menuPlaceholder.getParent();
        this.optionsMenuLayer = new OptionsMenuLayer(this.context, parent);
        parent.addView((View)this.optionsMenuLayer, menuPlaceholder.getLayoutParams());
        this.optionsMenuLayer.setCallback(this.optionsMenuCallBack);
    }

    public void initControlsMap() {
        this.controlsMap = new HashMap();
        this.hiddenViews = new LinkedHashSet();
        this.controlsMap.put("playLarge", (View)this.controlsView);
        this.controlsMap.put("play", (View)this.smallPlayPauseContainer);
        this.controlsMap.put("fullscreen", (View)this.fullscreenButton);
        this.controlsMap.put("menu", (View)this.optionsMenuButton);
        this.controlsMap.put("seekbar", this.playerView.findViewById(R.id.exo_progress));
        this.controlsMap.put("topChrome", (View)this.topBar);
        this.controlsMap.put("bottomChrome", (View)this.bottomBar);
        this.controlsMap.put("time", this.playerView.findViewById(R.id.time_components));
    }

    public void configView(boolean isVideo, boolean isLive, boolean isDVR, boolean hasCast) {
        this.isLive = isLive;
        this.isVideo = isVideo;
        this.isDVR = isDVR;
        this.hasCast = hasCast;
        if (isVideo) {
            this.playerView.setControllerHideOnTouch(true);
            this.playerView.setControllerShowTimeoutMs(2000);
            this.topBar.setVisibility(0);
            this.smallPlayPauseContainer.setVisibility(8);
            this.optionsMenuButton.setVisibility(this.hasMenu ? 0 : 8);
            if (isLive) {
                this.castButton.setVisibility(8);
                this.progressControls.setVisibility(isDVR ? 0 : 4);
                this.liveButton.setVisibility(0);
            } else {
                this.castButton.setVisibility(hasCast ? 0 : 8);
                this.progressControls.setVisibility(0);
                this.liveButton.setVisibility(8);
            }
        } else {
            this.playerView.setControllerHideOnTouch(false);
            this.playerView.setControllerShowTimeoutMs(-1);
            this.topBar.setVisibility(8);
            this.fullscreenButton.setVisibility(8);
            this.smallPlayPauseContainer.setVisibility(0);
            this.controlsView.setVisibility(8);
            this.optionsMenuButton.setVisibility(8);
            if (isLive) {
                this.progressControls.setVisibility(4);
            } else {
                this.progressControls.setVisibility(0);
            }
            this.castButton.setVisibility(8);
        }
        this.postConfigUi();
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.topbar_menu_button) {
            this.optionsMenuLayer.showMenu();
            this.menuWasPlaying = this.player.isPlayingAd() || this.player.getPlayWhenReady() && (this.player.getPlaybackState() == 3 || this.player.getPlaybackState() == 2);
            this.player.setPlayWhenReady(false);
            this.playerView.hideController();
        } else if (viewId == R.id.cast_image_container) {
            this.playerView.findViewById(R.id.cast_dummy_button).performClick();
        } else if (viewId == R.id.topbar_live_button) {
            if (this.player != null) {
                this.player.seekToDefaultPosition();
            }
        } else if (viewId == R.id.fullscreen_button) {
            this.doToggleFullscreen();
        }
    }

    public void setPlayer(@NonNull SimpleExoPlayer simpleExoPlayer) {
        this.player = simpleExoPlayer;
        this.playerView.setPlayer(this.player);
    }

    public void setEnableControls(boolean flag) {
        this.playerView.setUseController(flag);
    }

    public void setVideoTitle(String title) {
        this.videoTitle.setText((CharSequence)title);
    }

    public void configureSubTitle(SambaMedia.CaptionsConfig captionsConfig) {
        Typeface typeface = Typeface.create((Typeface)null, (int)0);
        CaptionStyleCompat captionStyleCompat = new CaptionStyleCompat(captionsConfig.color, 0, 0, 0, 0, typeface);
        this.playerView.getSubtitleView().setStyle(captionStyleCompat);
        this.playerView.getSubtitleView().setFixedTextSize(2, captionsConfig.size);
    }

    public void setupMenu(PlayerMediaSourceInterface playerMediaSource, Format selectedVideo, Format selectedSubtitle, boolean isAbrEnabled) {
        if (!this.isVideo) {
            this.outputSheetView = null;
            this.outputSheetDialog = null;
            this.captionSheetView = null;
            this.captionsSheetDialog = null;
            this.speedSheetDialog = null;
            this.speedSheetView = null;
            this.optionsMenuButton.setVisibility(8);
            return;
        }
        if (playerMediaSource.getVideoOutputsTracks() != null && playerMediaSource.getVideoOutputsTracks().length > 1) {
            this.initOutputMenu(playerMediaSource, selectedVideo, isAbrEnabled);
        } else {
            this.outputSheetView = null;
            this.outputSheetDialog = null;
        }
        if (playerMediaSource.getSubtitles() != null && playerMediaSource.getSubtitles().length > 1) {
            this.initCaptionMenu(playerMediaSource, selectedSubtitle);
        } else {
            this.captionSheetView = null;
            this.captionsSheetDialog = null;
        }
        if (!this.isLive) {
            this.initSpeedMenu();
        } else {
            this.speedSheetDialog = null;
            this.speedSheetView = null;
        }
        this.hasMenu = this.captionsSheetDialog != null || this.outputSheetDialog != null || this.speedSheetDialog != null;
        this.optionsMenuButton.setVisibility(this.hasMenu && !this.hiddenViews.contains(this.optionsMenuButton) ? 0 : 8);
        this.optionsMenuLayer.setCaptionsButtonVisibility(this.captionsSheetDialog != null);
        this.optionsMenuLayer.setHdButtonVisibility(this.outputSheetDialog != null);
        this.optionsMenuLayer.setSpeedButtonVisibility(this.speedSheetDialog != null);
    }

    private void initCaptionMenu(final PlayerMediaSourceInterface playerMediaSource, Format currentCaption) {
        final TrackGroupArray captions = playerMediaSource.getSubtitles();
        this.captionSheetView = ((Activity)this.context).getLayoutInflater().inflate(R.layout.action_sheet, null);
        TextView title = (TextView)this.captionSheetView.findViewById(R.id.action_sheet_title);
        title.setText((CharSequence)this.context.getString(R.string.captions));
        final ListView menuList = (ListView)this.captionSheetView.findViewById(R.id.sheet_list);
        final CaptionsSheetAdapter adapter = new CaptionsSheetAdapter(this.context, captions);
        menuList.setAdapter((ListAdapter)adapter);
        if (currentCaption != null) {
            for (int i = 0; i < captions.length; ++i) {
                if (captions.get(i).getFormat(0) != currentCaption) continue;
                adapter.currentIndex = i;
            }
        } else {
            adapter.currentIndex = 0;
        }
        menuList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SambaSimplePlayerView.this.closeCaptionMenu();
                TrackGroup format = captions.get(position);
                playerMediaSource.setSubtitle(format);
                menuList.smoothScrollToPosition(0);
                adapter.currentIndex = position;
            }
        });
        menuList.deferNotifyDataSetChanged();
        this.captionsSheetDialog = this.setupMenuDialog(this.captionSheetView);
    }

    private void initOutputMenu(final PlayerMediaSourceInterface playerMediaSource, Format currentOutput, boolean isAbrEnabled) {
        TrackGroup outputs = playerMediaSource.getVideoOutputsTracks();
        this.outputSheetView = ((Activity)this.context).getLayoutInflater().inflate(R.layout.action_sheet, null);
        TextView title = (TextView)this.outputSheetView.findViewById(R.id.action_sheet_title);
        title.setText((CharSequence)this.context.getString(R.string.output));
        final ListView menuList = (ListView)this.outputSheetView.findViewById(R.id.sheet_list);
        final OutputSheetAdapter adapter = new OutputSheetAdapter(this.context, outputs, isAbrEnabled);
        menuList.setAdapter((ListAdapter)adapter);
        adapter.currentIndex = currentOutput != null ? outputs.indexOf(currentOutput) + (isAbrEnabled ? 1 : 0) : 0;
        menuList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SambaSimplePlayerView.this.closeOutputMenu();
                Format format = (Format)adapter.getItem(position);
                playerMediaSource.setVideoOutputTrack(format);
                menuList.smoothScrollToPosition(0);
                adapter.currentIndex = position;
            }
        });
        menuList.deferNotifyDataSetChanged();
        this.outputSheetDialog = this.setupMenuDialog(this.outputSheetView);
    }

    private void initSpeedMenu() {
        this.speedSheetView = ((Activity)this.context).getLayoutInflater().inflate(R.layout.action_sheet, null);
        TextView title = (TextView)this.speedSheetView.findViewById(R.id.action_sheet_title);
        title.setText((CharSequence)this.context.getString(R.string.speed));
        final ListView menuList = (ListView)this.speedSheetView.findViewById(R.id.sheet_list);
        final float[] speeds = new float[]{0.25f, 0.5f, 1.0f, 1.5f, 2.0f};
        final float[] audioPitch = new float[]{0.25f, 0.5f, 1.0f, 1.5f, 2.0f};
        final SpeedSheetAdapter adapter = new SpeedSheetAdapter(this.context, speeds);
        menuList.setAdapter((ListAdapter)adapter);
        for (int i = 0; i < speeds.length; ++i) {
            if (this.player.getPlaybackParameters().speed != speeds[i]) continue;
            adapter.currentIndex = i;
        }
        menuList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SambaSimplePlayerView.this.closeSpeedMenu();
                SambaSimplePlayerView.this.player.setPlaybackParameters(new PlaybackParameters(speeds[position], audioPitch[2]));
                menuList.smoothScrollToPosition(0);
                adapter.currentIndex = position;
            }
        });
        menuList.deferNotifyDataSetChanged();
        this.speedSheetDialog = this.setupMenuDialog(this.speedSheetView);
    }

    public BottomSheetDialog setupMenuDialog(View view) {
        BottomSheetDialog bottomSheetDialog = new BottomSheetDialog(this.context);
        bottomSheetDialog.setContentView(view);
        bottomSheetDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (SambaSimplePlayerView.this.optionsMenuLayer != null) {
                    SambaSimplePlayerView.this.optionsMenuLayer.hideMenu();
                }
                if (SambaSimplePlayerView.this.menuWasPlaying) {
                    SambaSimplePlayerView.this.player.setPlayWhenReady(true);
                    SambaSimplePlayerView.this.playerView.hideController();
                } else {
                    SambaSimplePlayerView.this.playerView.showController();
                }
                if (SambaSimplePlayerView.this.isFullscreen) {
                    ((Activity)SambaSimplePlayerView.this.context).getWindow().getDecorView().setSystemUiVisibility(5638);
                }
            }
        });
        BottomSheetBehavior bottomSheetBehavior = BottomSheetBehavior.from((View)((View)view.getParent()));
        bottomSheetBehavior.setHideable(false);
        bottomSheetBehavior.setPeekHeight(Integer.MAX_VALUE);
        return bottomSheetDialog;
    }

    public void closeOutputMenu() {
        this.outputSheetDialog.dismiss();
        if (this.optionsMenuLayer != null) {
            this.optionsMenuLayer.hideMenu();
        }
    }

    public void closeCaptionMenu() {
        this.captionsSheetDialog.dismiss();
        if (this.optionsMenuLayer != null) {
            this.optionsMenuLayer.hideMenu();
        }
    }

    public void closeSpeedMenu() {
        this.speedSheetDialog.dismiss();
        if (this.optionsMenuLayer != null) {
            this.optionsMenuLayer.hideMenu();
        }
    }

    public SimpleExoPlayerView getPlayerView() {
        return this.playerView;
    }

    public void setFullscreenCallback(FullscreenCallback fullscreenCallback) {
        this.fullscreenCallback = fullscreenCallback;
    }

    public void doToggleFullscreen() {
        this.setFullscreen(!this.isFullscreen);
    }

    public void setFullscreen(boolean newValue) {
        this.setFullscreen(newValue, false);
    }

    public void setFullscreen(boolean newValue, boolean isReverseLandscape) {
        if (this.isFullscreen == newValue && this.isReverseLandscape == isReverseLandscape) {
            return;
        }
        if (this.fullscreenCallback == null) {
            return;
        }
        final Activity activity = (Activity)this.context;
        if (!newValue) {
            this.fullscreenCallback.onReturnFromFullscreen();
            activity.setRequestedOrientation(1);
            activity.getWindow().getDecorView().setSystemUiVisibility(0);
            this.playerContainer.setLayoutParams(this.originalContainerLayoutParams);
            this.fullscreenButton.setImageResource(R.drawable.sambaplayer_ic_fullscreen);
            this.isFullscreen = newValue;
            this.isReverseLandscape = isReverseLandscape;
        } else {
            this.fullscreenCallback.onGoToFullscreen();
            activity.setRequestedOrientation(isReverseLandscape ? 8 : 0);
            activity.getWindow().getDecorView().setSystemUiVisibility(5638);
            activity.getWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int i) {
                    if ((i & 4) == 0 && SambaSimplePlayerView.this.optionsMenuLayer != null && SambaSimplePlayerView.this.playerView != null && !SambaSimplePlayerView.this.optionsMenuLayer.isVisible()) {
                        SambaSimplePlayerView.this.playerView.showController();
                    }
                    if (SambaSimplePlayerView.this.isFullscreen && activity != null) {
                        activity.getWindow().getDecorView().setSystemUiVisibility(5638);
                    }
                }
            });
            this.playerContainer.setLayoutParams(Util.getLayoutParamsBasedOnParent((View)this.playerContainer, -1, -1));
            this.fullscreenButton.setImageResource(R.drawable.sambaplayer_ic_fullscreen_exit);
            this.isFullscreen = newValue;
            this.isReverseLandscape = isReverseLandscape;
        }
    }

    public boolean isFullscreen() {
        return this.isFullscreen;
    }

    public void destroyInternal() {
        this.destroyDialogs();
        this.setEnableControls(false);
        this.optionsMenuLayer.setCallback(null);
        this.fullscreenCallback = null;
        this.originalContainerLayoutParams = null;
        if (this.optionsMenuLayer != null) {
            ((ViewGroup)this.optionsMenuLayer.getParent()).removeView((View)this.optionsMenuLayer);
        }
        if (this.playerView != null) {
            ((ViewGroup)this.playerView.getParent()).removeView((View)this.playerView);
        }
        this.optionsMenuLayer = null;
        this.playerView = null;
        this.destroyCastPlayer();
    }

    private void destroyDialogs() {
        if (this.outputSheetView != null) {
            ((ListView)this.outputSheetView.findViewById(R.id.sheet_list)).setOnItemClickListener(null);
        }
        if (this.captionSheetView != null) {
            ((ListView)this.captionSheetView.findViewById(R.id.sheet_list)).setOnItemClickListener(null);
        }
        if (this.speedSheetView != null) {
            ((ListView)this.speedSheetView.findViewById(R.id.sheet_list)).setOnItemClickListener(null);
        }
        if (this.outputSheetDialog != null) {
            this.outputSheetDialog.cancel();
        }
        if (this.captionsSheetDialog != null) {
            this.captionsSheetDialog.cancel();
        }
        if (this.speedSheetDialog != null) {
            this.speedSheetDialog.cancel();
        }
        this.outputSheetView = null;
        this.captionSheetView = null;
        this.speedSheetView = null;
        this.outputSheetDialog = null;
        this.captionsSheetDialog = null;
        this.speedSheetDialog = null;
    }

    public void setThemeColor(int themeColor) {
        this.customTimeBar.setDefaultBarColor(themeColor);
        this.progressBar.getIndeterminateDrawable().mutate().setColorFilter(themeColor, PorterDuff.Mode.MULTIPLY);
        this.smallProgressBar.getIndeterminateDrawable().mutate().setColorFilter(themeColor, PorterDuff.Mode.MULTIPLY);
    }

    public void updatePlayPause(PlayPauseState playPauseState) {
        this.playSmallButton.setVisibility(playPauseState == PlayPauseState.Loading ? 8 : (playPauseState == PlayPauseState.Pause ? 0 : 8));
        this.pauseSmallButton.setVisibility(playPauseState == PlayPauseState.Loading ? 8 : (playPauseState == PlayPauseState.Playing ? 0 : 8));
        this.smallProgressBar.setVisibility(playPauseState == PlayPauseState.Loading ? 0 : 8);
        this.loadingView.setVisibility(playPauseState == PlayPauseState.Loading && this.isVideo ? 0 : 8);
        if (!this.hiddenViews.contains(this.controlsView)) {
            this.controlsView.setVisibility(playPauseState == PlayPauseState.Loading || !this.isVideo ? 8 : 0);
        }
    }

    public void setControlsVisible(boolean state, String ... controls) {
        if (state) {
            if (controls == null || controls.length == 0) {
                for (Map.Entry<String, View> pair : this.controlsMap.entrySet()) {
                    this.hiddenViews.remove(pair.getValue());
                }
            } else {
                for (String control : controls) {
                    View view = this.controlsMap.get(control);
                    this.hiddenViews.remove(view);
                }
            }
            this.configView(this.isVideo, this.isVideo, this.isDVR, this.hasCast);
        } else {
            if (controls == null || controls.length == 0) {
                for (Map.Entry<String, View> pair : this.controlsMap.entrySet()) {
                    this.hiddenViews.add(pair.getValue());
                }
            } else {
                for (String control : controls) {
                    View view = this.controlsMap.get(control);
                    this.hiddenViews.add(view);
                }
            }
            this.postConfigUi();
        }
    }

    private void postConfigUi() {
        for (View view : this.hiddenViews) {
            boolean isSeekBar = view.equals(this.controlsMap.get("seekbar"));
            int visibility = isSeekBar ? 4 : 8;
            view.setVisibility(visibility);
        }
    }

    public void setChromeColor(int color) {
        this.topBar.setBackgroundColor(color);
        this.bottomBar.setBackgroundColor(color);
    }

    public void setBackgroundColor(int color) {
        this.playerView.findViewById(R.id.exo_playback_layout).setBackgroundColor(color);
    }

    public void createCastPlayer(final @NonNull CastPlayer castPlayer, int themeColor, final ArrayList<SambaMedia.Caption> captions) {
        this.sambaCastPlayer = castPlayer;
        if (this.castControlView == null) {
            this.castControlView = new PlaybackControlView(this.context);
            ((CustomTimeBar)this.castControlView.findViewById(R.id.exo_progress)).setDefaultBarColor(themeColor);
            this.playerContainer.addView((View)this.castControlView, new ViewGroup.LayoutParams(-1, -1));
        }
        this.castControlView.setPlayer((Player)this.sambaCastPlayer);
        this.castControlView.setShowTimeoutMs(-1);
        this.castControlView.findViewById(R.id.play_pause_container).setVisibility(8);
        this.castControlView.findViewById(R.id.topbar_live_button).setVisibility(8);
        this.castControlView.findViewById(R.id.fullscreen_button).setVisibility(8);
        if (captions != null && captions.size() > 1) {
            this.castControlView.findViewById(R.id.topbar_menu_button).setVisibility(0);
            this.castControlView.findViewById(R.id.topbar_menu_button).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (SambaSimplePlayerView.this.castOptionsMenu == null) {
                        SambaSimplePlayerView.this.castOptionsMenu = new CastOptionsMenu(SambaSimplePlayerView.this.playerContainer, SambaSimplePlayerView.this.context, castPlayer, SambaSimplePlayerView.this.castControlView, captions);
                    }
                    SambaSimplePlayerView.this.castOptionsMenu.show();
                }
            });
        } else {
            this.castControlView.findViewById(R.id.topbar_menu_button).setVisibility(8);
        }
        this.castControlView.findViewById(R.id.exo_play).setVisibility(8);
        this.castControlView.findViewById(R.id.exo_pause).setVisibility(8);
        this.castControlView.findViewById(R.id.cast_image_container).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SambaSimplePlayerView.this.castControlView.findViewById(R.id.cast_dummy_button).performClick();
            }
        });
        ((ImageButton)this.castControlView.findViewById(R.id.cast_image_container)).setImageDrawable(this.context.getResources().getDrawable(R.drawable.sambaplayer_cast_connected));
        ((TextView)this.castControlView.findViewById(R.id.video_title_text)).setText(this.videoTitle.getText());
    }

    public void destroyCastPlayer() {
        if (this.castControlView != null && this.playerContainer != null) {
            this.playerContainer.removeView((View)this.castControlView);
        }
        if (this.castOptionsMenu != null) {
            this.castOptionsMenu.destroy();
        }
        this.castOptionsMenu = null;
        this.castControlView = null;
        this.sambaCastPlayer = null;
    }

    public void showCast() {
        this.castControlView.setVisibility(0);
        this.playerView.setVisibility(8);
    }

    public void hideCast() {
        if (this.castOptionsMenu != null) {
            this.castOptionsMenu.hide();
        }
        this.castControlView.setVisibility(8);
        this.playerView.setVisibility(0);
    }

    public static interface FullscreenCallback {
        public void onGoToFullscreen();

        public void onReturnFromFullscreen();
    }
}

