/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.cast;

import android.app.MediaRouteButton;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.LayoutInflater;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.Status;
import com.sambatech.player.R;
import com.sambatech.player.event.SambaCastListener;
import java.io.IOException;

public final class SambaCast {
    private final CastStateListener stateListener = new CastStateListener(){

        public void onCastStateChanged(int i) {
            Log.i((String)"cast", (String)("state: " + i));
        }
    };
    private final AppVisibilityListener appVisibilityListener = new AppVisibilityListener(){

        public void onAppEnteredForeground() {
            Log.i((String)"cast", (String)"foreground");
        }

        public void onAppEnteredBackground() {
            Log.i((String)"cast", (String)"background");
        }
    };
    private final SessionManagerListener<CastSession> sessionManagerListener = new SessionManagerListener<CastSession>(){

        public void onSessionStarting(CastSession castSession) {
            Log.i((String)"cast", (String)"starting");
        }

        public void onSessionStarted(CastSession castSession, String s) {
            Log.i((String)"cast", (String)("started " + s));
            this.onApplicationConnected(castSession);
        }

        public void onSessionStartFailed(CastSession castSession, int i) {
            Log.i((String)"cast", (String)("start failed " + i));
            this.onApplicationDisconnected();
        }

        public void onSessionEnding(CastSession castSession) {
            Log.i((String)"cast", (String)"ending");
        }

        public void onSessionEnded(CastSession castSession, int i) {
            Log.i((String)"cast", (String)"ended");
            this.onApplicationDisconnected();
        }

        public void onSessionResuming(CastSession castSession, String s) {
            Log.i((String)"cast", (String)("resuming " + s));
        }

        public void onSessionResumed(CastSession castSession, boolean b) {
            Log.i((String)"cast", (String)("resumed " + b));
            this.onApplicationConnected(castSession);
        }

        public void onSessionResumeFailed(CastSession castSession, int i) {
            Log.i((String)"cast", (String)("resume failed " + i));
            this.onApplicationDisconnected();
        }

        public void onSessionSuspended(CastSession castSession, int i) {
            Log.i((String)"cast", (String)("suspended " + i));
        }

        private void onApplicationConnected(CastSession castSession) {
            if (SambaCast.this.listener != null) {
                SambaCast.this.listener.onConnected(castSession);
            }
        }

        private void onApplicationDisconnected() {
            if (SambaCast.this.listener != null) {
                SambaCast.this.listener.onDisconnected();
            }
        }
    };
    private MediaRouteButton castButton;
    private SessionManager sessionManager;
    private CastContext castContext;
    private SambaCastListener listener;

    public SambaCast(@NonNull Context context) {
        int status = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
        if (status != 0) {
            return;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        this.castButton = (MediaRouteButton)inflater.inflate(R.layout.cast_button, null);
        this.castContext = CastContext.getSharedInstance((Context)context);
        this.sessionManager = this.castContext.getSessionManager();
    }

    public MediaRouteButton getButton() {
        return this.castButton;
    }

    public void setEventListener(SambaCastListener listener) {
        this.listener = listener;
    }

    public void notifyActivityResume() {
        this.castContext.addCastStateListener(this.stateListener);
        this.castContext.addAppVisibilityListener(this.appVisibilityListener);
        this.sessionManager.addSessionManagerListener(this.sessionManagerListener, CastSession.class);
    }

    public void notifyActivityPause() {
        this.castContext.removeCastStateListener(this.stateListener);
        this.castContext.removeAppVisibilityListener(this.appVisibilityListener);
        this.sessionManager.removeSessionManagerListener(this.sessionManagerListener, CastSession.class);
    }

    public void pauseCast() {
        if (this.hasMediaSession(true)) {
            this.sessionManager.getCurrentCastSession().sendMessage("urn:x-cast:com.sambatech.player", "{\"type\": \"pause\"}").setResultCallback((ResultCallback)new ResultCallbacks<Status>(){

                public void onSuccess(@NonNull Status status) {
                    Log.i((String)"message", (String)"Message Sent OK: namespace:urn:x-cast:com.sambatech.player message:urn:x-cast:com.sambatech.player");
                }

                public void onFailure(@NonNull Status status) {
                    Log.i((String)"message", (String)"Sending message failed");
                }
            });
        }
    }

    public void playCast() {
        if (this.hasMediaSession(true)) {
            this.sessionManager.getCurrentCastSession().sendMessage("urn:x-cast:com.sambatech.player", "{\"type\": \"play\"}").setResultCallback((ResultCallback)new ResultCallbacks<Status>(){

                public void onSuccess(@NonNull Status status) {
                    Log.i((String)"message", (String)"Message Sent OK: namespace:urn:x-cast:com.sambatech.player message:urn:x-cast:com.sambatech.player");
                }

                public void onFailure(@NonNull Status status) {
                    Log.i((String)"message", (String)"Sending message failed");
                }
            });
        }
    }

    public void seekTo(int posisiton) {
        String seekRequest = String.format("{\"type\": \"seek\", \"data\": %s }", posisiton / 1000);
        if (this.hasMediaSession(true) && this.hasMediaSession(true)) {
            this.sessionManager.getCurrentCastSession().sendMessage("urn:x-cast:com.sambatech.player", seekRequest).setResultCallback((ResultCallback)new ResultCallbacks<Status>(){

                public void onSuccess(@NonNull Status status) {
                    Log.i((String)"message", (String)"Message Sent OK: namespace:urn:x-cast:com.sambatech.player message:urn:x-cast:com.sambatech.player");
                }

                public void onFailure(@NonNull Status status) {
                    Log.i((String)"message", (String)"Sending message failed");
                }
            });
        }
    }

    public void registerDeviceForProgress(boolean register) {
        String registerRequest = String.format("{\"type\": \"registerForProgressUpdate\", \"data\": %s }", register);
        if (this.hasMediaSession(true)) {
            this.sessionManager.getCurrentCastSession().sendMessage("urn:x-cast:com.sambatech.player", registerRequest).setResultCallback((ResultCallback)new ResultCallbacks<Status>(){

                public void onSuccess(@NonNull Status status) {
                    Log.i((String)"message", (String)"Message Sent OK: namespace:urn:x-cast:com.sambatech.player message:urn:x-cast:com.sambatech.player");
                }

                public void onFailure(@NonNull Status status) {
                    Log.i((String)"message", (String)"Sending message failed");
                }
            });
        }
    }

    public void stopCasting() {
        this.sessionManager.endCurrentSession(true);
    }

    public boolean isCasting() {
        if (this.sessionManager != null && this.sessionManager.getCurrentCastSession() != null) {
            return this.sessionManager.getCurrentCastSession().isConnected() || this.sessionManager.getCurrentCastSession().isConnecting();
        }
        return false;
    }

    public void setMute(boolean mute) {
        try {
            this.sessionManager.getCurrentCastSession().setMute(mute);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setVolume(double volume) {
        try {
            this.sessionManager.getCurrentCastSession().setVolume(volume);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CastSession getCastSession() {
        return this.sessionManager.getCurrentCastSession();
    }

    private boolean hasMediaSession(boolean validateCastConnectingState) {
        boolean isCastSessionInConnectingMode;
        if (this.sessionManager.getCurrentCastSession() == null) {
            return false;
        }
        boolean isCastSessionValid = this.sessionManager.getCurrentCastSession().isConnected();
        if (validateCastConnectingState && (isCastSessionInConnectingMode = this.sessionManager.getCurrentCastSession().isConnecting())) {
            return false;
        }
        return isCastSessionValid;
    }
}

