/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.app.Activity;
import android.app.MediaRouteButton;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.google.android.exoplayer.BehindLiveWindowException;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.Status;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.exoplayerextensions.UnsupportedDrmException;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.PlaybackControlLayer;
import com.google.android.libraries.mediaframework.layeredvideo.SimpleVideoPlayer;
import com.sambatech.player.R;
import com.sambatech.player.adapter.CaptionsAdapter;
import com.sambatech.player.adapter.OutputAdapter;
import com.sambatech.player.cast.CastDRM;
import com.sambatech.player.cast.CastObject;
import com.sambatech.player.cast.CastOptionsProvider;
import com.sambatech.player.cast.CastQuery;
import com.sambatech.player.cast.SambaCast;
import com.sambatech.player.event.SambaCastListener;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.model.SambaPlayerError;
import com.sambatech.player.plugins.Captions;
import com.sambatech.player.plugins.PluginManager;
import com.sambatech.player.utils.Helpers;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class SambaPlayer
extends FrameLayout {
    private final ExoplayerWrapper.PlaybackListener playbackListener = new ExoplayerWrapper.PlaybackListener(){

        public void onStateChanged(boolean playWhenReady, int playbackState) {
            Log.i((String)"SambaPlayer", (String)("state: " + playWhenReady + " " + playbackState + "; playing: " + SambaPlayer.this.isPlaying()));
            switch (playbackState) {
                case 4: {
                    if (playWhenReady) {
                        if (!SambaPlayer.this._hasStarted) {
                            SambaPlayer.this._hasStarted = true;
                            SambaPlayer.this._currentRetryIndex = 0;
                            SambaPlayer.this.initOutputMenu();
                            SambaPlayer.this.destroyError();
                            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.START));
                            SambaPlayer.this.player.show();
                            if (!((SambaPlayer)SambaPlayer.this).media.isLive && SambaPlayer.this._initialTime > 0.0f) {
                                SambaPlayer.this.seek(SambaPlayer.this._initialTime);
                                SambaPlayer.this._initialTime = 0.0f;
                            }
                            if (SambaPlayer.this._initialOutput != -1) {
                                SambaPlayer.this.switchOutput(SambaPlayer.this._initialOutput);
                                SambaPlayer.this._initialOutput = -1;
                            }
                            if (SambaPlayer.this._initialFullscreen != null) {
                                SambaPlayer.this.player.setFullscreen(SambaPlayer.this._initialFullscreen.booleanValue());
                                SambaPlayer.this._initialFullscreen = null;
                            }
                        }
                        SambaPlayer.this.dispatchPlay();
                    } else {
                        SambaPlayer.this.dispatchPause();
                    }
                    SambaPlayer.this.player.hideLoading();
                    break;
                }
                case 5: {
                    if (!playWhenReady) break;
                    SambaPlayer.this.stopProgressTimer();
                    SambaPlayer.this.pause();
                    SambaPlayer.this.seek(0.0f);
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FINISH));
                    SambaPlayer.this._hasFinished = true;
                    SambaPlayer.this.player.hideLoading();
                    break;
                }
                case 3: {
                    SambaPlayer.this.player.showLoading();
                    SambaPlayer.this.stopErrorTimer();
                    final AtomicInteger secs = new AtomicInteger(20);
                    SambaPlayer.this.errorTimer = new Timer();
                    SambaPlayer.this.errorTimer.scheduleAtFixedRate(new TimerTask(){

                        @Override
                        public void run() {
                            ((Activity)SambaPlayer.this.getContext()).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (secs.get() == 0) {
                                        SambaPlayer.this.stopErrorTimer();
                                        SambaPlayer.this._initialOutput = 0;
                                    }
                                    secs.decrementAndGet();
                                }
                            });
                        }
                    }, 0L, 1000L);
                }
            }
        }

        public void onError(final Exception e) {
            Log.d((String)"SambaPlayer", (String)("Error: " + SambaPlayer.this.media), (Throwable)e);
            String msg = "Voc\u00ea est\u00e1 offline! Verifique sua conex\u00e3o.";
            SambaPlayerError.Severity severity = SambaPlayerError.Severity.recoverable;
            boolean isBehindLiveWindowException = e.getCause() instanceof BehindLiveWindowException;
            if (SambaPlayer.this._initialTime == 0.0f) {
                SambaPlayer.this._initialTime = SambaPlayer.this.getCurrentTime();
            }
            if (isBehindLiveWindowException) {
                SambaPlayer.this._initialOutput = SambaPlayer.this.player.getTrackCount(0) - 1;
            }
            SambaPlayer.this._initialFullscreen = SambaPlayer.this.player.isFullscreen();
            SambaPlayer.this.destroyInternal();
            if (e.getCause() instanceof UnsupportedDrmException) {
                msg = String.format("Voc\u00ea n\u00e3o tem permiss\u00e3o para %s", ((SambaPlayer)SambaPlayer.this).media.isAudioOnly ? "ouvir este \u00e1udio." : "assistir este v\u00eddeo.");
                severity = SambaPlayerError.Severity.critical;
            } else if (isBehindLiveWindowException) {
                msg = "Instabilidade na rede ou no envio de dados.";
                severity = SambaPlayerError.Severity.minor;
                SambaPlayer.this.create(false);
            } else if (Helpers.isNetworkAvailable(SambaPlayer.this.getContext())) {
                msg = "Conectando...";
                severity = SambaPlayerError.Severity.info;
                try {
                    HttpURLConnection con = (HttpURLConnection)new URL(String.format("%s://www.google.com", new Object[]{((SambaPlayer)SambaPlayer.this).media.request.protocol})).openConnection();
                    con.setConnectTimeout(1000);
                    con.setReadTimeout(1000);
                    Helpers.requestUrl(con, new Helpers.RequestCallback(){

                        @Override
                        public void onSuccess(String response) {
                            ((Activity)SambaPlayer.this.getContext()).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (SambaPlayer.this._currentBackupIndex < ((SambaPlayer)SambaPlayer.this).media.backupUrls.length) {
                                        ((SambaPlayer)SambaPlayer.this).media.url = ((SambaPlayer)SambaPlayer.this).media.backupUrls[SambaPlayer.this._currentBackupIndex++];
                                        SambaPlayer.this.create(false);
                                        SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), "Conectando...", SambaPlayerError.Severity.info, e));
                                        return;
                                    }
                                    SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), "Ocorreu um erro! Por favor, tente mais tarde...", SambaPlayerError.Severity.critical, e));
                                }
                            });
                        }

                        @Override
                        public void onError(Exception e2, String response) {
                            SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), "Voc\u00ea est\u00e1 offline! Verifique sua conex\u00e3o.", SambaPlayerError.Severity.recoverable, e2));
                        }
                    });
                }
                catch (IOException e1) {
                    msg = "Ocorreu um erro! Por favor, tente novamente.";
                    severity = SambaPlayerError.Severity.recoverable;
                }
            } else if (SambaPlayer.this._currentRetryIndex++ < ((SambaPlayer)SambaPlayer.this).media.retriesTotal) {
                final AtomicInteger secs = new AtomicInteger(8);
                SambaPlayer.this.stopErrorTimer();
                SambaPlayer.this.errorTimer = new Timer();
                SambaPlayer.this.errorTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        ((Activity)SambaPlayer.this.getContext()).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (secs.get() == 0) {
                                    SambaPlayer.this.stopErrorTimer();
                                    SambaPlayer.this.create(false);
                                }
                                SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), secs.get() > 0 ? String.format("Reconectando em %ss", secs) : "Conectando...", SambaPlayerError.Severity.info, e, R.drawable.ic_nosignal_disable));
                                secs.decrementAndGet();
                            }
                        });
                    }
                }, 0L, 1000L);
                return;
            }
            SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), msg, severity, e));
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.RESIZE, width, height, unappliedRotationDegrees, Float.valueOf(pixelWidthHeightRatio)));
        }
    };
    private final PlaybackControlLayer.PlayCallback playListener = new PlaybackControlLayer.PlayCallback(){

        public void onPlay() {
            if (SambaPlayer.this.player.getPlaybackState() == 5) {
                SambaPlayer.this.seek(0.0f);
            }
        }
    };
    private final PlaybackControlLayer.FullscreenCallback fullscreenListener = new PlaybackControlLayer.FullscreenCallback(){

        public void onGoToFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN));
        }

        public void onReturnFromFullscreen() {
            SambaPlayer.this._wasAutoFS = false;
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN_EXIT));
        }
    };
    private final Runnable progressDispatcher = new Runnable(){

        @Override
        public void run() {
            if (SambaPlayer.this.player == null) {
                return;
            }
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PROGRESS, Float.valueOf(SambaPlayer.this.getCurrentTime()), Float.valueOf(SambaPlayer.this.getDuration())));
        }
    };
    private final SambaCastListener castListener = new SambaCastListener(){
        RemoteMediaClient castPlayer;
        private int lastPosition = 0;
        private final PlaybackControlLayer.InterceptableListener interceptableListener = new PlaybackControlLayer.InterceptableListener(){

            public boolean onPlay() {
                SambaPlayer.this.dispatchPlay();
                SambaPlayer.this.sambaCast.playCast();
                return false;
            }

            public boolean onPause() {
                SambaPlayer.this.dispatchPause();
                SambaPlayer.this.sambaCast.pauseCast();
                return false;
            }

            public boolean onSeek(int position) {
                SambaPlayer.this.sambaCast.seekTo(position);
                return false;
            }

            public int getCurrentTime() {
                return castPlayer != null ? (int)castPlayer.getApproximateStreamPosition() : 0;
            }

            public int getDuration() {
                return castPlayer != null ? (int)castPlayer.getStreamDuration() : 0;
            }
        };

        @Override
        public void onConnected(CastSession castSession) {
            SambaPlayer.this.stopProgressTimer();
            SambaPlayer.this.pause();
            RemoteMediaClient remoteMediaClient = castSession.getRemoteMediaClient();
            if (remoteMediaClient == null) {
                return;
            }
            SambaPlayer.this.player.setInterceptableListener(this.interceptableListener);
            SambaPlayer.this.player.setAutoHide(false);
            SambaPlayer.this.player.setControlsVisible(false, new String[]{"output", "caption"});
            MediaMetadata movieMetadata = new MediaMetadata(1);
            movieMetadata.putString("com.google.android.gms.cast.metadata.TITLE", ((SambaPlayer)SambaPlayer.this).media.title);
            movieMetadata.putString("com.google.android.gms.cast.metadata.SUBTITLE", ((SambaPlayer)SambaPlayer.this).media.title);
            CastQuery qs = new CastQuery(true, CastOptionsProvider.environment.toString(), CastOptionsProvider.appId, (int)SambaPlayer.this.getCurrentTime(), SambaPlayer.this.getCaption());
            CastObject castObject = new CastObject(((SambaPlayer)SambaPlayer.this).media.title, ((SambaPlayer)SambaPlayer.this).media.id, (int)SambaPlayer.this.getDuration(), ((SambaPlayer)SambaPlayer.this).media.themeColorHex, ((SambaPlayer)SambaPlayer.this).media.projectHash, qs, "", CastOptionsProvider.playerUrl);
            if (((SambaPlayer)SambaPlayer.this).media.drmRequest != null) {
                castObject.setDrm(new CastDRM(((SambaPlayer)SambaPlayer.this).media.drmRequest.getLicenseParam("SessionId"), ((SambaPlayer)SambaPlayer.this).media.drmRequest.getLicenseParam("Ticket")));
            }
            MediaInfo mediaInfo = new MediaInfo.Builder(castObject.toString()).setStreamType(1).setContentType("video/mp4").setMetadata(movieMetadata).build();
            remoteMediaClient.load(mediaInfo, false, 0L).setResultCallback((ResultCallback)new ResultCallbacks<RemoteMediaClient.MediaChannelResult>(){

                public void onSuccess(@NonNull RemoteMediaClient.MediaChannelResult mediaChannelResult) {
                    Log.d((String)"load", (String)mediaChannelResult.getStatus().toString());
                }

                public void onFailure(@NonNull Status status) {
                    Log.d((String)"load", (String)status.toString());
                }
            });
            SambaPlayer.this.sambaCast.registerDeviceForProgress(true);
            this.lastPosition = 0;
            Cast.MessageReceivedCallback messageReceived = new Cast.MessageReceivedCallback(){

                public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
                    Log.i((String)"Message Received", (String)(castDevice.toString() + namespace + message));
                    try {
                        String type;
                        JSONObject jsonObject = new JSONObject(message);
                        if (jsonObject.has("progress") && jsonObject.has("duration")) {
                            float progress = jsonObject.getInt("progress");
                            float duration = jsonObject.getInt("duration");
                            lastPosition = (int)progress;
                            if (SambaPlayer.this.player != null) {
                                SambaPlayer.this.player.setCurrentTime(progress, duration);
                            }
                        } else if (jsonObject.has("type") && (type = (jsonObject = new JSONObject(message)).getString("type")).equalsIgnoreCase("finish")) {
                            SambaPlayer.this.sambaCast.stopCasting();
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            };
            try {
                castSession.setMessageReceivedCallbacks("urn:x-cast:com.sambatech.player", messageReceived);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.castPlayer = remoteMediaClient;
            SambaPlayer.this.player.updatePlayPauseButton(true);
        }

        @Override
        public void onDisconnected() {
            SambaPlayer.this.player.setControlsVisible(true, new String[]{SambaPlayer.this.outputMenu != null && !SambaPlayer.this.controlsHidden.contains("output") ? "output" : null, SambaPlayer.this.captionMenu != null && !SambaPlayer.this.controlsHidden.contains("caption") ? "caption" : null});
            SambaPlayer.this.player.setAutoHide(true);
            SambaPlayer.this.player.seek(this.lastPosition * 1000);
            this.lastPosition = 0;
            SambaPlayer.this.player.setInterceptableListener(null);
            SambaPlayer.this.play();
            SambaPlayer.this.startProgressTimer();
        }
    };
    private SimpleVideoPlayer player;
    private View errorScreen;
    @NonNull
    private SambaMediaConfig media = new SambaMediaConfig();
    private Timer progressTimer;
    private boolean _hasStarted;
    private boolean _hasFinished;
    private OrientationEventListener orientationEventListener;
    private View outputMenu;
    private View captionMenu;
    private SambaCast sambaCast;
    private boolean _autoFsMode;
    private boolean _enableControls;
    private boolean _wasAutoFS;
    private boolean _disabled;
    private int _currentBackupIndex;
    private int _currentRetryIndex;
    private float _initialTime = 0.0f;
    private int _initialOutput = -1;
    private Boolean _initialFullscreen = null;
    private Timer errorTimer;
    private int _outputOffset;
    private List<String> controlsHidden = new ArrayList<String>();

    public SambaPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SambaPlayer, 0, 0));
    }

    public void setMedia(@NonNull SambaMedia media) {
        SambaMediaConfig m;
        this.media = m = new SambaMediaConfig(media);
        this._initialTime = m.initialTime;
        if (m.blockIfRooted && Helpers.isDeviceRooted()) {
            this._disabled = true;
            this.dispatchError(SambaPlayerError.rootedDevice);
            return;
        }
        this.destroy();
        PluginManager.getInstance().onLoad(this);
    }

    @NonNull
    public SambaMedia getMedia() {
        return this.media;
    }

    public void play(boolean abrEnabled, int outputIndex) {
        this._outputOffset = abrEnabled ? 0 : 1;
        this._initialOutput = outputIndex;
        if (this._disabled || this.errorScreen != null) {
            return;
        }
        if (!PluginManager.getInstance().isLoaded()) {
            PluginManager.getInstance().setPendingPlay(true);
            return;
        }
        if (this.player == null) {
            this.create();
            return;
        }
        this.player.play();
    }

    public void play() {
        this.play(true, -1);
    }

    public void pause() {
        if (this.player == null || !this._hasStarted) {
            return;
        }
        this.player.pause();
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        this.player.stop();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.STOP));
    }

    public void seek(float position) {
        if (this.player == null) {
            return;
        }
        this.player.seek(Math.round(position * 1000.0f));
    }

    public void setEnableControls(boolean flag) {
        if (this.media.isAudioOnly) {
            return;
        }
        if (this.player != null) {
            if (flag) {
                this.player.enableControls();
            } else {
                this.player.disableControls();
            }
        } else {
            this._enableControls = flag;
        }
    }

    public void setHideControls(String ... controls) {
        if (controls.length == 0) {
            return;
        }
        this.controlsHidden = Arrays.asList(controls);
        if (this.player == null) {
            return;
        }
        this.player.setControlsVisible(false, controls);
    }

    public void setFullscreen(boolean flag) {
        if (this.player == null) {
            return;
        }
        this.player.setFullscreen(flag);
    }

    public boolean isFullscreen() {
        return this.player != null && this.player.isFullscreen();
    }

    public void show() {
        if (this.player == null) {
            return;
        }
        this.player.show();
    }

    public void hide() {
        if (this.player == null) {
            return;
        }
        this.player.hide();
    }

    public void setAutoFullscreenMode(boolean flag) {
        this._autoFsMode = flag;
    }

    public float getCurrentTime() {
        return this.player != null ? (float)this.player.getCurrentPosition() / 1000.0f : 0.0f;
    }

    public float getDuration() {
        return this.player != null ? (float)this.player.getDuration() / 1000.0f : this.media.duration;
    }

    public boolean isPlaying() {
        return this.player != null && this.player.shouldBePlaying();
    }

    public boolean hasStarted() {
        return this._hasStarted;
    }

    public boolean hasFinished() {
        return this._hasFinished;
    }

    public void changeOutput(@NonNull SambaMedia.Output output) {
        if (output.url == null || output.url.isEmpty()) {
            Log.e((String)"SambaPlayer", (String)("URL not found for output \"" + output.label + "\"."));
            return;
        }
        int currentPosition = this.player.getCurrentPosition();
        for (SambaMedia.Output o : this.media.outputs) {
            o.isDefault = o.label.equals(output.label);
        }
        this.media.url = output.url;
        this.destroyInternal();
        this.create(false);
        this.player.seek(currentPosition);
    }

    public void switchOutput(int index) {
        if (this.player == null || this.outputMenu == null) {
            return;
        }
        this.outputMenu.setTag((Object)(index + this._outputOffset));
        this.player.setSelectedTrack(index + this._outputOffset);
    }

    public int getCurrentOutputIndex() {
        return (this.outputMenu != null && this.outputMenu.getTag() != null ? (Integer)this.outputMenu.getTag() : this.media.defaultOutputIndex) - this._outputOffset;
    }

    public void changeCaption(int index) {
        Captions plugin = (Captions)PluginManager.getInstance().getPlugin(Captions.class);
        if (plugin == null) {
            return;
        }
        plugin.changeCaption(index);
    }

    public String getCaption() {
        if (this.captionMenu == null) {
            return null;
        }
        CaptionsAdapter adapter = (CaptionsAdapter)((ListView)this.captionMenu.findViewById(R.id.menu_list)).getAdapter();
        SambaMedia.Caption caption = (SambaMedia.Caption)adapter.getItem(adapter.currentIndex);
        return String.format("[%s,ffcc00,42]", caption.language);
    }

    public void setSambaCast(@NonNull SambaCast sambaCast) {
        this.sambaCast = sambaCast;
        this.setupCast();
    }

    public void destroy() {
        this.destroy(null);
    }

    public void destroy(SambaPlayerError error) {
        PluginManager.getInstance().onDestroy();
        this.destroyInternal();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.UNLOAD));
        if (error != null) {
            this.showError(error);
        } else {
            this.destroyError();
        }
    }

    private void applyAttributes(TypedArray attrs) {
        try {
            this.setAutoFullscreenMode(attrs.getBoolean(R.styleable.SambaPlayer_autoFullscreenMode, false));
            this.setEnableControls(attrs.getBoolean(R.styleable.SambaPlayer_enableControls, true));
        }
        finally {
            attrs.recycle();
        }
    }

    private void create() {
        this.create(true, true);
    }

    private void create(boolean notify) {
        this.create(notify, true);
    }

    private void create(boolean notify, boolean isAutoPlay) {
        if (this.player != null) {
            Log.i((String)"SambaPlayer", (String)"Player already created!");
            return;
        }
        if (this.media.url == null || this.media.url.isEmpty()) {
            this.dispatchError(SambaPlayerError.emptyUrl);
            return;
        }
        Video.VideoType videoType = Video.VideoType.OTHER;
        switch (this.media.type.toLowerCase()) {
            case "hls": {
                videoType = Video.VideoType.HLS;
                break;
            }
            case "dash": {
                videoType = Video.VideoType.DASH;
            }
        }
        this.player = new SimpleVideoPlayer((Activity)this.getContext(), (FrameLayout)this, new Video(this.media.url, videoType, this.media.drmRequest), this.media.title, !notify && isAutoPlay || isAutoPlay && (this.sambaCast == null || !this.sambaCast.isCasting()) && (this.media.adUrl == null || this.media.adUrl.isEmpty()), this.media.isAudioOnly);
        this.player.setThemeColor(this.media.themeColor);
        this.player.moveSurfaceToBackground();
        if (this.media.isLive) {
            ((Activity)this.getContext()).findViewById(R.id.time_container).setVisibility(4);
            this.player.setControlsVisible(false, new String[]{"seekbar"});
            this.player.addActionButton(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_live), this.getContext().getString(R.string.live), null);
        }
        this.player.addPlaybackListener(this.playbackListener);
        this.player.setPlayCallback(this.playListener);
        if (this.media.isAudioOnly) {
            this.player.setControlsVisible(true, new String[]{"play"});
            this.player.setControlsVisible(false, new String[]{"fullscreen", "playLarge", "topChrome"});
            this.player.setBackgroundColor(-12369085);
            this.player.setChromeColor(0);
        } else {
            this.player.setFullscreenCallback(this.fullscreenListener);
        }
        if (!this.controlsHidden.isEmpty()) {
            this.setHideControls(this.controlsHidden.toArray(new String[0]));
        }
        this.orientationEventListener = new OrientationEventListener(this.getContext()){
            {
                this.enable();
            }

            public void onOrientationChanged(int orientation) {
                if (Settings.System.getInt((ContentResolver)SambaPlayer.this.getContext().getContentResolver(), (String)"accelerometer_rotation", (int)0) == 0 || !SambaPlayer.this._autoFsMode || SambaPlayer.this.player == null) {
                    return;
                }
                if (orientation <= 15 && orientation >= 0) {
                    if (SambaPlayer.this._wasAutoFS && SambaPlayer.this.player.isFullscreen()) {
                        SambaPlayer.this.player.setFullscreen(false);
                    }
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PORTRAIT));
                } else {
                    boolean isReverseLandscape;
                    boolean bl = isReverseLandscape = orientation >= 80 && orientation <= 100;
                    if (orientation >= 260 && orientation <= 290 || isReverseLandscape) {
                        if (!SambaPlayer.this.player.isFullscreen()) {
                            SambaPlayer.this._wasAutoFS = true;
                            SambaPlayer.this.player.setFullscreen(true, isReverseLandscape);
                        }
                        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LANDSCAPE));
                    }
                }
            }
        };
        if (!this.media.isAudioOnly) {
            this.initCaptionMenu();
            if (!this._enableControls) {
                this.player.disableControls();
            }
            PluginManager.getInstance().onInternalPlayerCreated(this.player);
            if (notify) {
                SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LOAD, new Object[]{this}));
            }
        }
        this.setupCast();
        if (this.sambaCast != null && this.sambaCast.isCasting()) {
            this.castListener.onConnected(this.sambaCast.getCastSession());
        }
    }

    private View initDialog(@StringRes int titleRes, ListAdapter adapter, AdapterView.OnItemClickListener itemListener, View.OnClickListener cancelListener) {
        View dialog = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.menu_layout, null);
        TextView cancelButton = (TextView)dialog.findViewById(R.id.menu_cancel_button);
        TextView title = (TextView)dialog.findViewById(R.id.menu_label);
        title.setText((CharSequence)this.getContext().getString(titleRes));
        cancelButton.setOnClickListener(cancelListener);
        ListView menuList = (ListView)dialog.findViewById(R.id.menu_list);
        menuList.setAdapter(adapter);
        menuList.setOnItemClickListener(itemListener);
        menuList.deferNotifyDataSetChanged();
        return dialog;
    }

    private void initOutputMenu() {
        if (this.player == null || this.controlsHidden.contains("output")) {
            return;
        }
        MediaFormat[] tracks = this.player.getTrackFormats(0);
        if (this.media.isAudioOnly || tracks.length <= 1) {
            return;
        }
        this.outputMenu = this.initDialog(R.string.output, (ListAdapter)new OutputAdapter(this.getContext(), tracks, this, this._outputOffset), new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SambaPlayer.this.player.closeOutputMenu();
                SambaPlayer.this.switchOutput(position);
            }
        }, new View.OnClickListener(){

            public void onClick(View v) {
                SambaPlayer.this.player.closeOutputMenu();
            }
        });
        this.player.setOutputMenu(this.outputMenu);
        this.player.setControlsVisible(true, new String[]{"output"});
    }

    private void initCaptionMenu() {
        if (this.player == null || this.media.isAudioOnly || this.media.captions == null || this.media.captions.size() == 0 || this.controlsHidden.contains("caption")) {
            return;
        }
        this.captionMenu = this.initDialog(R.string.captions, (ListAdapter)new CaptionsAdapter(this.getContext(), this.media.captions), new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SambaPlayer.this.player.closeCaptionMenu();
                SambaPlayer.this.changeCaption(position);
            }
        }, new View.OnClickListener(){

            public void onClick(View v) {
                SambaPlayer.this.player.closeCaptionMenu();
            }
        });
        this.player.setCaptionMenu(this.captionMenu);
        this.player.setControlsVisible(true, new String[]{"caption"});
    }

    private void destroyInternal() {
        this.stopProgressTimer();
        this.stopErrorTimer();
        if (this.player == null) {
            return;
        }
        this.stop();
        this.player.setFullscreen(false);
        if (this.outputMenu != null) {
            ((ListView)this.outputMenu.findViewById(R.id.menu_list)).setOnItemClickListener(null);
            this.outputMenu.findViewById(R.id.menu_cancel_button).setOnClickListener(null);
        }
        if (this.captionMenu != null) {
            ((ListView)this.captionMenu.findViewById(R.id.menu_list)).setOnItemClickListener(null);
            this.captionMenu.findViewById(R.id.menu_cancel_button).setOnClickListener(null);
        }
        this.orientationEventListener.disable();
        this.player.removePlaybackListener(this.playbackListener);
        this.player.setPlayCallback(null);
        this.player.setFullscreenCallback(null);
        if (this.sambaCast != null) {
            this.player.setInterceptableListener(null);
            this.sambaCast.setEventListener(null);
        }
        this.player.setControlsVisible(false, new String[0]);
        this.player.release();
        this.outputMenu = null;
        this.captionMenu = null;
        this.orientationEventListener = null;
        this.player = null;
        this._hasStarted = false;
        this._hasFinished = false;
        this._disabled = false;
    }

    private void showError(@NonNull SambaPlayerError error) {
        if (this.errorScreen == null) {
            this.errorScreen = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.error_screen, (ViewGroup)this, false);
        }
        TextView textView = (TextView)this.errorScreen.findViewById(R.id.error_message);
        textView.setText((CharSequence)error.toString());
        ImageButton retryButton = (ImageButton)this.errorScreen.findViewById(R.id.retry_button);
        retryButton.setVisibility(error.getSeverity() == SambaPlayerError.Severity.recoverable ? 0 : 8);
        retryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SambaPlayer.this.destroyInternal();
                SambaPlayer.this.create(false);
            }
        });
        if (this.media.isAudioOnly) {
            if (error.getSeverity() == SambaPlayerError.Severity.recoverable) {
                textView.setVisibility(8);
            } else {
                textView.setCompoundDrawables(null, null, null, null);
            }
        } else if (error.getDrawableRes() > 0) {
            textView.setCompoundDrawablesWithIntrinsicBounds(0, error.getDrawableRes(), 0, 0);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.error_icon, 0, 0);
        }
        if (this.errorScreen.getParent() == null) {
            this.addView(this.errorScreen);
        }
    }

    private void destroyError() {
        this.stopErrorTimer();
        if (this.errorScreen == null) {
            return;
        }
        this.errorScreen.findViewById(R.id.retry_button).setOnClickListener(null);
        this.removeView(this.errorScreen);
        this.errorScreen = null;
    }

    private void startProgressTimer() {
        if (this.progressTimer != null) {
            return;
        }
        this.progressTimer = new Timer();
        this.progressTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)SambaPlayer.this.getContext()).runOnUiThread(SambaPlayer.this.progressDispatcher);
            }
        }, 0L, 250L);
    }

    private void stopProgressTimer() {
        if (this.progressTimer == null) {
            return;
        }
        this.progressTimer.cancel();
        this.progressTimer.purge();
        this.progressTimer = null;
    }

    private void stopErrorTimer() {
        if (this.errorTimer == null) {
            return;
        }
        this.errorTimer.cancel();
        this.errorTimer.purge();
        this.errorTimer = null;
    }

    private void dispatchPlay() {
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PLAY));
        this.startProgressTimer();
    }

    private void dispatchPause() {
        this.stopProgressTimer();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PAUSE));
    }

    private void dispatchError(@NonNull SambaPlayerError error) {
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.ERROR, new Object[]{error}));
        switch (error.getSeverity()) {
            case critical: {
                this.destroy(error);
                break;
            }
            case info: 
            case recoverable: {
                this.showError(error);
            }
        }
    }

    private void setupCast() {
        if (this.sambaCast == null || this.media.isLive || this.media.isAudioOnly) {
            return;
        }
        this.sambaCast.setEventListener(this.castListener);
        if (this.player != null) {
            MediaRouteButton button = this.sambaCast.getButton();
            ViewGroup parent = (ViewGroup)button.getParent();
            if (parent != null) {
                parent.removeView((View)button);
            }
            this.player.addActionButton((View)button);
        }
    }

    public static final class Controls
    extends com.google.android.libraries.mediaframework.layeredvideo.Controls {
    }
}

