/*
 * Decompiled with CFR 0.152.
 */
package com.rbrooks.indefinitepagerindicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.rbrooks.indefinitepagerindicator.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 82\u00020\u00012\u00020\u0002:\u000289B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010 \u001a\u00020!2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\"\u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\b\u0010#\u001a\u00020\bH\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\bH\u0002J\b\u0010&\u001a\u00020\bH\u0002J\b\u0010'\u001a\u00020\bH\u0002J\u0010\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u0017H\u0002J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0017H\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\u0014J\u0010\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\bH\u0016J \u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u00020\bH\u0016J\u0010\u00107\u001a\u00020!2\u0006\u00104\u001a\u00020\bH\u0016R\u0012\u0010\n\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator;", "Landroid/view/View;", "Landroid/support/v4/view/ViewPager$OnPageChangeListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dotColor", "dotCount", "dotPaint", "Landroid/graphics/Paint;", "dotRadiusPx", "dotSeparationDistancePx", "fadingDotCount", "intermediateSelectedItemPosition", "internalRecyclerScrollListener", "Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator$InternalRecyclerScrollListener;", "interpolator", "Landroid/view/animation/DecelerateInterpolator;", "offsetPercent", "", "recyclerView", "Landroid/support/v7/widget/RecyclerView;", "selectedDotColor", "selectedDotPaint", "selectedDotRadiusPx", "selectedItemPosition", "viewPager", "Landroid/support/v4/view/ViewPager;", "attachToRecyclerView", "", "attachToViewPager", "getCalculatedWidth", "getDotXCoordinate", "pagerPosition", "getDotYCoordinate", "getPagerItemCount", "getPaint", "xCoordinate", "getRadius", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onPageScrollStateChanged", "state", "onPageScrolled", "position", "positionOffset", "positionOffsetPixels", "onPageSelected", "Companion", "InternalRecyclerScrollListener", "indefinitepagerindicator_release"})
public final class IndefinitePagerIndicator
extends View
implements ViewPager.OnPageChangeListener {
    private RecyclerView recyclerView;
    private ViewPager viewPager;
    private InternalRecyclerScrollListener internalRecyclerScrollListener;
    private final DecelerateInterpolator interpolator;
    private int dotCount;
    private int fadingDotCount;
    private int selectedDotRadiusPx;
    private int dotRadiusPx;
    private int dotSeparationDistancePx;
    @ColorInt
    private int dotColor;
    @ColorInt
    private int selectedDotColor;
    private final Paint selectedDotPaint;
    private final Paint dotPaint;
    private int selectedItemPosition;
    private int intermediateSelectedItemPosition;
    private float offsetPercent;
    private static final int DEFAULT_DOT_COUNT = 5;
    private static final int DEFAULT_FADING_DOT_COUNT = 1;
    private static final int DEFAULT_DOT_RADIUS_DP = 4;
    private static final float DEFAULT_SELECTED_DOT_RADIUS_DP = 5.5f;
    private static final int DEFAULT_DOT_SEPARATION_DISTANCE_DP = 10;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        int n = 0;
        int n2 = this.getPagerItemCount();
        while (n < n2) {
            void i;
            float xCoordinate = this.getDotXCoordinate((int)i);
            float normalizedX = (float)(this.getWidth() / 2) + xCoordinate;
            canvas.drawCircle(normalizedX, (float)this.getDotYCoordinate(), this.getRadius(xCoordinate), this.getPaint(xCoordinate));
            ++i;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.getCalculatedWidth(), 2 * this.selectedDotRadiusPx);
    }

    private final float getDotXCoordinate(int pagerPosition) {
        return (float)((pagerPosition - this.intermediateSelectedItemPosition) * (this.dotSeparationDistancePx + 2 * this.dotRadiusPx)) + (float)(this.dotSeparationDistancePx + 2 * this.dotRadiusPx) * this.offsetPercent;
    }

    private final int getDotYCoordinate() {
        return this.selectedDotRadiusPx;
    }

    private final float getRadius(float xCoordinate) {
        float f;
        float xAbs = Math.abs(xCoordinate);
        float largeDotThreshold = (float)this.dotCount / (float)2 * (float)(this.dotSeparationDistancePx + 2 * this.dotRadiusPx);
        if (xAbs < (float)((this.dotSeparationDistancePx + 2 * this.dotRadiusPx) / 2)) {
            f = this.selectedDotRadiusPx;
        } else if (xAbs <= largeDotThreshold) {
            f = this.dotRadiusPx;
        } else {
            float percentTowardsEdge = (xAbs - largeDotThreshold) / ((float)this.getCalculatedWidth() / 2.01f - largeDotThreshold);
            f = this.interpolator.getInterpolation(1.0f - percentTowardsEdge) * (float)this.dotRadiusPx;
        }
        return f;
    }

    private final Paint getPaint(float xCoordinate) {
        return Math.abs(xCoordinate) < (float)((this.dotSeparationDistancePx + 2 * this.dotRadiusPx) / 2) ? this.selectedDotPaint : this.dotPaint;
    }

    private final int getCalculatedWidth() {
        int maxNumVisibleDots = this.dotCount + 2 * this.fadingDotCount;
        return (maxNumVisibleDots - 1) * (this.dotSeparationDistancePx + 2 * this.dotRadiusPx) + 2 * this.dotRadiusPx;
    }

    public final void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        block2: {
            ViewPager viewPager = this.viewPager;
            if (viewPager != null) {
                viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            }
            this.viewPager = null;
            RecyclerView recyclerView2 = this.recyclerView;
            if (recyclerView2 != null) {
                recyclerView2.removeOnScrollListener((RecyclerView.OnScrollListener)this.internalRecyclerScrollListener);
            }
            this.recyclerView = recyclerView;
            this.internalRecyclerScrollListener = new InternalRecyclerScrollListener();
            RecyclerView recyclerView3 = this.recyclerView;
            if (recyclerView3 == null) break block2;
            recyclerView3.addOnScrollListener((RecyclerView.OnScrollListener)this.internalRecyclerScrollListener);
        }
    }

    public final void attachToViewPager(@Nullable ViewPager viewPager) {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.internalRecyclerScrollListener);
        }
        this.recyclerView = null;
        ViewPager viewPager2 = this.viewPager;
        if (viewPager2 != null) {
            viewPager2.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        ViewPager viewPager3 = this.viewPager = viewPager;
        if (viewPager3 != null) {
            viewPager3.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        ViewPager viewPager4 = viewPager;
        Integer n = viewPager4 != null ? Integer.valueOf(viewPager4.getCurrentItem()) : null;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        this.selectedItemPosition = n;
    }

    private final int getPagerItemCount() {
        int n;
        if (this.recyclerView != null) {
            RecyclerView recyclerView = this.recyclerView;
            Integer n2 = recyclerView != null && (recyclerView = recyclerView.getAdapter()) != null ? Integer.valueOf(recyclerView.getItemCount()) : null;
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            n = n2;
        } else if (this.viewPager != null) {
            ViewPager viewPager = this.viewPager;
            Integer n3 = viewPager != null && (viewPager = viewPager.getAdapter()) != null ? Integer.valueOf(viewPager.getCount()) : null;
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            n = n3;
        } else {
            n = 0;
        }
        return n;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.intermediateSelectedItemPosition = position;
        this.offsetPercent = positionOffset * (float)-1;
        this.invalidate();
    }

    public void onPageSelected(int position) {
        this.selectedItemPosition = position;
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
    }

    @JvmOverloads
    public IndefinitePagerIndicator(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.interpolator = new DecelerateInterpolator();
        this.dotCount = IndefinitePagerIndicator.Companion.getDEFAULT_DOT_COUNT();
        this.fadingDotCount = IndefinitePagerIndicator.Companion.getDEFAULT_FADING_DOT_COUNT();
        float f = IndefinitePagerIndicator.Companion.getDEFAULT_SELECTED_DOT_RADIUS_DP();
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        this.selectedDotRadiusPx = IndefinitePagerIndicator.Companion.dpToPx(f, resources);
        float f2 = IndefinitePagerIndicator.Companion.getDEFAULT_DOT_RADIUS_DP();
        Resources resources2 = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        this.dotRadiusPx = IndefinitePagerIndicator.Companion.dpToPx(f2, resources2);
        float f3 = IndefinitePagerIndicator.Companion.getDEFAULT_DOT_SEPARATION_DISTANCE_DP();
        Resources resources3 = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources3, (String)"resources");
        this.dotSeparationDistancePx = IndefinitePagerIndicator.Companion.dpToPx(f3, resources3);
        this.dotColor = this.getResources().getColor(R.color.default_dot_color);
        this.selectedDotColor = this.getResources().getColor(R.color.default_selected_dot_color);
        this.selectedDotPaint = new Paint();
        this.dotPaint = new Paint();
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2;
            AttributeSet it = attributeSet2 = attributeSet;
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IndefinitePagerIndicator, 0, 0);
            this.dotCount = typedArray.getInteger(R.styleable.IndefinitePagerIndicator_dotCount, IndefinitePagerIndicator.Companion.getDEFAULT_DOT_COUNT());
            this.fadingDotCount = typedArray.getInt(R.styleable.IndefinitePagerIndicator_fadingDotCount, IndefinitePagerIndicator.Companion.getDEFAULT_FADING_DOT_COUNT());
            this.dotRadiusPx = typedArray.getDimensionPixelSize(R.styleable.IndefinitePagerIndicator_dotRadius, this.dotRadiusPx);
            this.selectedDotRadiusPx = typedArray.getDimensionPixelSize(R.styleable.IndefinitePagerIndicator_selectedDotRadius, this.selectedDotRadiusPx);
            this.dotColor = typedArray.getColor(R.styleable.IndefinitePagerIndicator_dotColor, this.dotColor);
            this.selectedDotColor = typedArray.getColor(R.styleable.IndefinitePagerIndicator_selectedDotColor, this.selectedDotColor);
            this.dotSeparationDistancePx = typedArray.getDimensionPixelSize(R.styleable.IndefinitePagerIndicator_dotSeparation, this.dotSeparationDistancePx);
        }
        this.selectedDotPaint.setStyle(Paint.Style.FILL);
        this.selectedDotPaint.setColor(this.selectedDotColor);
        this.dotPaint.setStyle(Paint.Style.FILL);
        this.dotPaint.setColor(this.dotColor);
    }

    @JvmOverloads
    public /* synthetic */ IndefinitePagerIndicator(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public IndefinitePagerIndicator(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public IndefinitePagerIndicator(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        DEFAULT_DOT_COUNT = 5;
        DEFAULT_FADING_DOT_COUNT = 1;
        DEFAULT_DOT_RADIUS_DP = 4;
        DEFAULT_SELECTED_DOT_RADIUS_DP = 5.5f;
        DEFAULT_DOT_SEPARATION_DISTANCE_DP = 10;
    }

    public static final /* synthetic */ float access$getOffsetPercent$p(IndefinitePagerIndicator $this) {
        return $this.offsetPercent;
    }

    public static final /* synthetic */ int access$getSelectedItemPosition$p(IndefinitePagerIndicator $this) {
        return $this.selectedItemPosition;
    }

    public static final /* synthetic */ void access$setRecyclerView$p(IndefinitePagerIndicator $this, @Nullable RecyclerView recyclerView) {
        $this.recyclerView = recyclerView;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\n\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0012\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator$InternalRecyclerScrollListener;", "Landroid/support/v7/widget/RecyclerView$OnScrollListener;", "(Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator;)V", "previousMostVisibleChild", "Landroid/view/View;", "calculatePercentVisible", "", "child", "getMostVisibleChild", "onScrolled", "", "recyclerView", "Landroid/support/v7/widget/RecyclerView;", "dx", "", "dy", "setIntermediateSelectedItemPosition", "mostVisibleChild", "indefinitepagerindicator_release"})
    public final class InternalRecyclerScrollListener
    extends RecyclerView.OnScrollListener {
        private View previousMostVisibleChild;

        public void onScrolled(@Nullable RecyclerView recyclerView, int dx, int dy) {
            int visibleItemPosition;
            View view = this.getMostVisibleChild();
            this.setIntermediateSelectedItemPosition(view);
            View view2 = view;
            if (view2 == null) {
                Intrinsics.throwNpe();
            }
            IndefinitePagerIndicator.this.offsetPercent = (float)view2.getLeft() / (float)view.getMeasuredWidth();
            RecyclerView recyclerView2 = recyclerView;
            Object object = recyclerView2 != null ? recyclerView2.getLayoutManager() : null;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.support.v7.widget.LinearLayoutManager");
            }
            LinearLayoutManager layoutManager = (LinearLayoutManager)object;
            int n = visibleItemPosition = dx >= 0 ? layoutManager.findLastVisibleItemPosition() : layoutManager.findFirstVisibleItemPosition();
            if (this.previousMostVisibleChild != layoutManager.findViewByPosition(visibleItemPosition)) {
                IndefinitePagerIndicator.this.selectedItemPosition = IndefinitePagerIndicator.this.intermediateSelectedItemPosition;
            }
            this.previousMostVisibleChild = view;
            IndefinitePagerIndicator.this.invalidate();
        }

        /*
         * WARNING - void declaration
         */
        private final View getMostVisibleChild() {
            View mostVisibleChild = null;
            float mostVisibleChildPercent = 0.0f;
            RecyclerView recyclerView = IndefinitePagerIndicator.this.recyclerView;
            Integer n = recyclerView != null && (recyclerView = recyclerView.getLayoutManager()) != null ? Integer.valueOf(recyclerView.getChildCount()) : null;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            int n2 = n - 1;
            boolean bl = false;
            if (n2 >= 0) {
                while (true) {
                    float percentVisible;
                    View child;
                    void i;
                    RecyclerView recyclerView2;
                    View view = (recyclerView2 = IndefinitePagerIndicator.this.recyclerView) != null && (recyclerView2 = recyclerView2.getLayoutManager()) != null ? recyclerView2.getChildAt((int)i) : (child = null);
                    if (child != null && (percentVisible = this.calculatePercentVisible(child)) >= mostVisibleChildPercent) {
                        mostVisibleChildPercent = percentVisible;
                        mostVisibleChild = child;
                    }
                    if (i == false) break;
                    --i;
                }
            }
            return mostVisibleChild;
        }

        private final float calculatePercentVisible(View child) {
            int left = child.getLeft();
            int right = child.getRight();
            int width = child.getWidth();
            return left < 0 ? (float)right / (float)width : (right > IndefinitePagerIndicator.this.getWidth() ? (float)(IndefinitePagerIndicator.this.getWidth() - left) / (float)width : 1.0f);
        }

        private final void setIntermediateSelectedItemPosition(View mostVisibleChild) {
            RecyclerView recyclerView = IndefinitePagerIndicator.this.recyclerView;
            Integer n = recyclerView != null && (recyclerView = recyclerView.findContainingViewHolder(mostVisibleChild)) != null ? Integer.valueOf(recyclerView.getAdapterPosition()) : null;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            IndefinitePagerIndicator.this.intermediateSelectedItemPosition = n;
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator$Companion;", "", "()V", "DEFAULT_DOT_COUNT", "", "getDEFAULT_DOT_COUNT", "()I", "DEFAULT_DOT_RADIUS_DP", "getDEFAULT_DOT_RADIUS_DP", "DEFAULT_DOT_SEPARATION_DISTANCE_DP", "getDEFAULT_DOT_SEPARATION_DISTANCE_DP", "DEFAULT_FADING_DOT_COUNT", "getDEFAULT_FADING_DOT_COUNT", "DEFAULT_SELECTED_DOT_RADIUS_DP", "", "getDEFAULT_SELECTED_DOT_RADIUS_DP", "()F", "dpToPx", "dp", "resources", "Landroid/content/res/Resources;", "indefinitepagerindicator_release"})
    public static final class Companion {
        private final int getDEFAULT_DOT_COUNT() {
            return DEFAULT_DOT_COUNT;
        }

        private final int getDEFAULT_FADING_DOT_COUNT() {
            return DEFAULT_FADING_DOT_COUNT;
        }

        private final int getDEFAULT_DOT_RADIUS_DP() {
            return DEFAULT_DOT_RADIUS_DP;
        }

        private final float getDEFAULT_SELECTED_DOT_RADIUS_DP() {
            return DEFAULT_SELECTED_DOT_RADIUS_DP;
        }

        private final int getDEFAULT_DOT_SEPARATION_DISTANCE_DP() {
            return DEFAULT_DOT_SEPARATION_DISTANCE_DP;
        }

        private final int dpToPx(float dp, Resources resources) {
            return (int)(dp * (float)(resources.getDisplayMetrics().densityDpi / 160));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

