/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils.builder;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class MyGsonBuilder {
    private static final String TAG = "MyGsonBuilder";
    private static MyGsonBuilder instance = null;
    private static GsonBuilder mGsonBuilder = null;
    private static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        public String read(JsonReader reader) throws IOException {
            try {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return "";
                }
                return reader.nextString();
            }
            catch (IllegalStateException e) {
                Log.e((String)MyGsonBuilder.TAG, (String)(e.toString() + "\r\n" + reader.toString()));
                reader.skipValue();
                return "";
            }
            catch (Exception e) {
                Log.e((String)MyGsonBuilder.TAG, (String)(e.toString() + "\r\n" + reader.toString()));
                return "";
            }
        }

        public void write(JsonWriter writer, String value) {
            try {
                if (value == null) {
                    writer.nullValue();
                    return;
                }
                writer.value(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private static final TypeAdapter<Integer> INTEGER = new TypeAdapter<Integer>(){

        public Integer read(JsonReader reader) throws IOException {
            try {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return 0;
                }
                return Integer.valueOf(reader.nextString());
            }
            catch (IllegalStateException e) {
                Log.e((String)MyGsonBuilder.TAG, (String)(e.toString() + "\r\n" + reader.toString()));
                reader.skipValue();
                return 0;
            }
            catch (Exception e) {
                Log.e((String)MyGsonBuilder.TAG, (String)(e.toString() + "\r\n" + reader.toString()));
                return 0;
            }
        }

        public void write(JsonWriter writer, Integer value) {
            try {
                writer.value(String.valueOf(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private static final TypeAdapter<Long> LONG = new TypeAdapter<Long>(){

        public Long read(JsonReader reader) throws IOException {
            try {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return 0L;
                }
                return Long.valueOf(reader.nextString());
            }
            catch (IllegalStateException e) {
                Log.e((String)MyGsonBuilder.TAG, (String)(e.toString() + "\r\n" + reader.toString()));
                reader.skipValue();
                return 0L;
            }
            catch (Exception e) {
                Log.e((String)MyGsonBuilder.TAG, (String)(e.toString() + "\r\n" + reader.toString()));
                return 0L;
            }
        }

        public void write(JsonWriter writer, Long value) {
            try {
                writer.value(String.valueOf(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private static final TypeAdapter<Double> DOUBLE = new TypeAdapter<Double>(){

        public Double read(JsonReader reader) throws IOException {
            try {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return 0.0;
                }
                return Double.valueOf(reader.nextString());
            }
            catch (IllegalStateException e) {
                Log.e((String)MyGsonBuilder.TAG, (String)(e.toString() + "\r\n" + reader.toString()));
                reader.skipValue();
                return 0.0;
            }
            catch (Exception e) {
                Log.e((String)MyGsonBuilder.TAG, (String)(e.toString() + "\r\n" + reader.toString()));
                return 0.0;
            }
        }

        public void write(JsonWriter writer, Double value) {
            try {
                writer.value(String.valueOf(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private static MyGsonBuilder getInstance() {
        if (instance == null) {
            instance = new MyGsonBuilder();
        }
        return instance;
    }

    public static synchronized Gson getGson() {
        if (mGsonBuilder == null) {
            MyGsonBuilder.getInstance();
        }
        return mGsonBuilder.create();
    }

    private MyGsonBuilder() {
        this.init();
    }

    private void init() {
        mGsonBuilder = new GsonBuilder();
        mGsonBuilder.registerTypeAdapter(String.class, STRING);
        mGsonBuilder.registerTypeAdapter(Integer.TYPE, INTEGER);
        mGsonBuilder.registerTypeAdapter(Long.TYPE, LONG);
        mGsonBuilder.registerTypeAdapter(Double.TYPE, DOUBLE);
    }
}

