/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import java.util.List;

public class UIUtil {
    private static Handler sHandler;

    public static Handler getHandler() {
        if (sHandler == null) {
            sHandler = new Handler(Looper.getMainLooper());
        }
        return sHandler;
    }

    @TargetApi(value=3)
    public static Thread getUIThread() {
        return Looper.getMainLooper().getThread();
    }

    public static boolean isOnUIThread() {
        return Thread.currentThread() == UIUtil.getUIThread();
    }

    public static void runOnUIThread(Runnable action) {
        if (!UIUtil.isOnUIThread()) {
            UIUtil.getHandler().post(action);
        } else {
            action.run();
        }
    }

    public static void postOnUIThread(Runnable action, long delay) {
        UIUtil.getHandler().postDelayed(action, delay);
    }

    public static boolean isMainProcess(Context context) {
        try {
            return context.getPackageName().equals(UIUtil.getProcessName(context));
        }
        catch (Exception e) {
            return false;
        }
    }

    @TargetApi(value=3)
    private static String getProcessName(Context context) {
        if (context != null) {
            int pid = Process.myPid();
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            List infoList = null;
            try {
                infoList = am.getRunningAppProcesses();
                for (ActivityManager.RunningAppProcessInfo apps : infoList) {
                    if (apps.pid != pid) continue;
                    return apps.processName;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return "";
    }

    public static interface Method<T> {
        public T call();
    }
}

