/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import java.text.DecimalFormat;

public class SizeConvertUtil {
    private static final long KB = 1024L;
    private static final long GB = 0x40000000L;
    private static final long MB = 0x100000L;
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.##");

    public static String formatSize(float sizeOfMB) {
        StringBuilder gameSize = new StringBuilder();
        if (sizeOfMB >= 1024.0f) {
            gameSize.append(decimalFormat.format(sizeOfMB / 1024.0f)).append(" GB");
        } else {
            gameSize.append(decimalFormat.format(sizeOfMB)).append(" MB");
        }
        return gameSize.toString();
    }

    public static long transMB2Byte(float sizeByMB) {
        return (long)(sizeByMB * 1048576.0f);
    }

    public static double transByte2MB(float sizeByByte) {
        return sizeByByte / 1048576.0f;
    }

    public static String transByte2MBAndFormat(float sizeByByte) {
        return decimalFormat.format(sizeByByte / 1048576.0f);
    }
}

