/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class IOUtils {
    private static final int BUFFER_SIZE = 8192;
    public static final String DEFAULT_ENCODING = "utf-8";

    private IOUtils() {
    }

    public static String readString(InputStream is) throws IOException {
        return IOUtils.readString(is, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream is, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        try {
            IOUtils.copy(is, sw, encoding);
            String string = sw.toString();
            return string;
        }
        finally {
            IOUtils.close(is);
            IOUtils.close(sw);
        }
    }

    private static void copy(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, encoding == null ? DEFAULT_ENCODING : encoding);
        char[] buffer = new char[8192];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static String readString(File file) throws IOException {
        return IOUtils.readString(file, DEFAULT_ENCODING);
    }

    public static String readString(File file, String encoding) throws IOException {
        return IOUtils.readString(new FileInputStream(file), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        byte[] byArray;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] result = new byte[(int)file.length()];
            ((InputStream)is).read(result);
            byArray = result;
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            throw throwable;
        }
        IOUtils.close(is);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            int read = 0;
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.close(is);
            IOUtils.close(baos);
        }
    }

    public static void writeString(String content, OutputStream os) throws IOException {
        IOUtils.writeString(content, os, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String content, OutputStream os, String encoding) throws IOException {
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(os, encoding));
            printWriter.write(content);
            printWriter.flush();
            os.flush();
        }
        finally {
            IOUtils.close(os);
        }
    }

    public static void write(InputStream is, OutputStream os) throws IOException {
        IOUtils.write(is, true, os, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream is, boolean closeInputStream, OutputStream os, boolean closeOutputStream) throws IOException {
        try {
            int count;
            byte[] buffer = new byte[8192];
            while ((count = is.read(buffer)) != -1) {
                os.write(buffer, 0, count);
            }
            os.flush();
        }
        finally {
            if (closeInputStream) {
                IOUtils.close(is);
            }
            if (closeOutputStream) {
                IOUtils.close(os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream is, File file) throws IOException {
        FileOutputStream os = null;
        try {
            int count;
            os = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((count = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, count);
            }
            os.flush();
        }
        finally {
            IOUtils.close(is);
            IOUtils.close(os);
        }
    }

    public static void write(byte[] data, File file) throws IOException {
        IOUtils.write(data, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] data, File file, boolean append) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file, append);
            ((OutputStream)os).write(data);
            os.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close(os);
    }

    public static void close(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

