/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.text.TextUtils;

public class FileNameUtil {
    private static final String ILLEGAL_REGX = "[`~!@#$%^&*()+=|{}':;',\\[\\]\\ <>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09/\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char LINUX_SEPARATOR = '/';

    public static String removeIllegalChars(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        return fileName.replaceAll(ILLEGAL_REGX, "_").trim();
    }

    public static String getBaseName(String filename) {
        return FileNameUtil.removeExtension(FileNameUtil.getFileName(filename));
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtil.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    private static int indexOfLastSeparator(String filename) {
        if (TextUtils.isEmpty((CharSequence)filename)) {
            return -1;
        }
        return filename.lastIndexOf(47);
    }

    public static String getFileName(String filename) {
        if (TextUtils.isEmpty((CharSequence)filename)) {
            return null;
        }
        int index = FileNameUtil.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    public static int getFirstSeparatorPos(String str, char separator) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return -1;
        }
        return str.indexOf(separator);
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileNameUtil.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileNameUtil.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getFullPath(String filename) {
        if (TextUtils.isEmpty((CharSequence)filename)) {
            return null;
        }
        int index = FileNameUtil.indexOfLastSeparator(filename);
        return filename.substring(0, index + 1);
    }
}

