/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class ArrayUtil {
    public static long[] toLongArray(List<Long> list) {
        if (list == null) {
            return null;
        }
        long[] longs = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            longs[i] = list.get(i);
        }
        return longs;
    }

    public static List<Long> toList(long[] longs) {
        if (longs == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (long l : longs) {
            list.add(l);
        }
        return list;
    }

    public static <T> T[] combineArray(T[] arr1, T[] arr2) {
        T[] elements = ArrayUtil.copyOfRange(arr1, 0, arr1.length + arr2.length);
        System.arraycopy(arr2, 0, elements, arr1.length, arr2.length);
        return elements;
    }

    public static <T> T[] insert(T[] array, int index, T element) {
        Object[] ret = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i < index ? array[i] : (i == index ? element : array[i - 1]);
        }
        return ret;
    }

    public static <T> T[] copyOfRange(T[] original, int start, int end) {
        int originalLength = original.length;
        if (start > end) {
            throw new IllegalArgumentException();
        }
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        Object[] result = (Object[])Array.newInstance(original.getClass().getComponentType(), resultLength);
        System.arraycopy(original, start, result, 0, copyLength);
        return result;
    }

    public static boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        for (int element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static int getIndex(String[] array, String value) {
        int index = 0;
        if (array == null) {
            return 0;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            index = i;
        }
        return index;
    }
}

