/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.alibaba.fastjson.JSON;
import com.ruijc.util.EncryptUtils;
import com.ruijc.util.MapUtils;
import com.ruijc.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpUtils {
    public static final String HTTP_PROTCOL = "http://";

    public static boolean checkSign(ServletRequest servletRequest, String string) {
        String string2;
        String string3 = servletRequest.getParameter(string);
        if (StringUtils.isBlank(string3)) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = servletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            hashMap.put(string2, servletRequest.getParameter(string2));
        }
        hashMap.put(string, "");
        string2 = EncryptUtils.md5(MapUtils.linkString(hashMap));
        boolean bl = string3.equals(string2);
        return bl;
    }

    public static void write(ServletResponse servletResponse, String string) throws IOException {
        block7: {
            servletResponse.setContentLength(-1);
            PrintWriter printWriter = null;
            ServletOutputStream servletOutputStream = null;
            try {
                printWriter = servletResponse.getWriter();
                printWriter.println(string);
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                return;
            }
            catch (Exception exception) {
                servletOutputStream = servletResponse.getOutputStream();
                servletOutputStream.println(string);
                return;
            }
            finally {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                if (servletOutputStream == null) break block7;
                servletOutputStream.flush();
                servletOutputStream.close();
            }
        }
    }

    public static void write(ServletResponse servletResponse, Object object) throws IOException {
        block7: {
            servletResponse.setContentLength(-1);
            servletResponse.setContentType("application/json;charset=utf-8");
            servletResponse.setCharacterEncoding("utf-8");
            object = JSON.toJSONString((Object)object);
            PrintWriter printWriter = null;
            ServletOutputStream servletOutputStream = null;
            try {
                printWriter = servletResponse.getWriter();
                printWriter.println((String)object);
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                return;
            }
            catch (Exception exception) {
                servletOutputStream = servletResponse.getOutputStream();
                servletOutputStream.println((String)object);
                return;
            }
            finally {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                if (servletOutputStream == null) break block7;
                servletOutputStream.flush();
                servletOutputStream.close();
            }
        }
    }

    public static String finalUrl(String object) {
        String string = object;
        try {
            object = new URL((String)object);
            object = (HttpURLConnection)((URL)object).openConnection();
            ((URLConnection)object).setConnectTimeout(300000);
            ((URLConnection)object).setReadTimeout(300000);
            ((HttpURLConnection)object).setRequestMethod("GET");
            ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            ((URLConnection)object).addRequestProperty("Accept-Charset", "UTF-8;");
            ((URLConnection)object).addRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; zh-CN; rv:1.9.2.8) Firefox/3.6.8");
            ((URLConnection)object).addRequestProperty("Referer", "http://icoolxue.com/");
            ((URLConnection)object).connect();
            if (((HttpURLConnection)object).getResponseCode() == 302 || ((HttpURLConnection)object).getResponseCode() == 301) {
                string = ((URLConnection)object).getHeaderField("Location");
                return HttpUtils.finalUrl(string);
            }
            ((HttpURLConnection)object).disconnect();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace(System.out);
        }
        return string;
    }

    public static String encode(String string) {
        return HttpUtils.encode(string, "UTF-8");
    }

    public static String encode(String string, String string2) {
        try {
            string2 = URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    public static String decode(String string) {
        return HttpUtils.decode(string, "UTF-8");
    }

    public static String decode(String string, String string2) {
        try {
            string2 = URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    public static String clientIP(ServletRequest servletRequest) {
        String string = "127.0.0.1";
        if (!(servletRequest instanceof HttpServletRequest)) {
            return string;
        }
        string = (servletRequest = (HttpServletRequest)servletRequest).getHeader("x-forwarded-for");
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = servletRequest.getHeader("Proxy-Client-IP");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = servletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = servletRequest.getRemoteAddr();
        }
        return string;
    }

    public static String getReferer(ServletRequest servletRequest) {
        String string = "";
        if (!(servletRequest instanceof HttpServletRequest)) {
            return string;
        }
        string = StringUtils.getString((servletRequest = (HttpServletRequest)servletRequest).getHeader("referer"), servletRequest.getHeader("Referer"));
        if (!StringUtils.isBlank(string) && !string.startsWith(HTTP_PROTCOL)) {
            string = string + HTTP_PROTCOL;
        }
        return string;
    }

    public static String getString(ServletRequest object) throws Exception {
        int n;
        int n2;
        char[] cArray = new char[object.getContentLength()];
        object = object.getReader();
        for (n = n2 = ((Reader)object).read(cArray); n < cArray.length; n += n2) {
            n2 = ((BufferedReader)object).read(cArray, n, cArray.length - n);
        }
        object = new StringBuilder((int)((double)cArray.length * 1.5));
        for (n2 = 0; n2 < cArray.length; ++n2) {
            n = cArray[n2];
            ((StringBuilder)object).append((char)n);
        }
        String string = ((StringBuilder)object).toString();
        return string;
    }

    public static boolean isAjax(ServletRequest object) {
        boolean bl = false;
        String string = object.getContentType();
        if (!StringUtils.isBlank(string) && string.contains("application/json")) {
            bl = true;
        }
        if (!bl && object instanceof HttpServletRequest && !StringUtils.isBlank((String)(object = ((HttpServletRequest)object).getHeader("method"))) && ((String)object).contains("ajax")) {
            bl = true;
        }
        return bl;
    }

    public static HttpServletRequest toHttp(ServletRequest servletRequest) {
        return (HttpServletRequest)servletRequest;
    }

    public static HttpServletResponse toHttp(ServletResponse servletResponse) {
        return (HttpServletResponse)servletResponse;
    }
}

