/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.ruijc.util.CollectionUtils;
import com.ruijc.util.serialize.ISerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KryoSerializerImpl<T>
implements ISerializer<T> {
    private Kryo kryo = new Kryo();

    @Override
    public <T> T deserialize(byte[] bytes) {
        Object result;
        if (CollectionUtils.isBlank(bytes)) {
            return null;
        }
        try {
            result = this.kryo.readObject(new Input(bytes), Object.class);
        }
        catch (Exception e) {
            result = null;
        }
        return (T)result;
    }

    @Override
    public byte[] serialize(Object object) {
        byte[] result2;
        if (object == null) {
            byte[] result2 = new byte[]{};
            return result2;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            Output output = new Output((OutputStream)stream);
            this.kryo.writeObject(output, object);
            output.close();
        }
        catch (Exception e) {
            result2 = new byte[]{};
        }
        result2 = stream.toByteArray();
        return result2;
    }
}

