/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.ruijc.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils {
    public static Map<String, Object> toMap(Object obj) {
        HashMap<String, Object> map = null;
        if (obj == null) {
            return map;
        }
        map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            map = null;
        }
        return map;
    }

    public static Map<String, String> toStringMap(Object obj) {
        HashMap<String, String> map = null;
        if (obj == null) {
            return map;
        }
        map = new HashMap<String, String>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                map.put(key, getter.invoke(obj, new Object[0]).toString());
            }
        }
        catch (Exception e) {
            map = null;
        }
        return map;
    }

    public static int getInt(Map<Object, Object> dataMap, Object key) {
        int ret;
        Object data = dataMap.get(key);
        try {
            ret = Integer.parseInt(data.toString());
        }
        catch (NumberFormatException e) {
            ret = 0;
        }
        return ret;
    }

    public static double getDouble(Map<Object, Object> dataMap, Object key) {
        double ret;
        Object data = dataMap.get(key);
        try {
            ret = Double.parseDouble(data.toString());
        }
        catch (NumberFormatException e) {
            ret = 0.0;
        }
        return ret;
    }

    public static long getLong(Map<Object, Object> dataMap, Object key) {
        long ret;
        Object data = dataMap.get(key);
        try {
            ret = Long.parseLong(data.toString());
        }
        catch (NumberFormatException e) {
            ret = 0L;
        }
        return ret;
    }

    public static String getString(Map<Object, Object> dataMap, Object key) {
        Object data = dataMap.get(key);
        return data.toString();
    }

    public static boolean check(Map<String, Boolean> data, String key) {
        boolean success = !data.containsKey(key) ? false : data.get(key);
        return success;
    }

    public static String linkString(Map<String, String> params) {
        String ret = "";
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (StringUtils.isBlank(value)) continue;
            ret = i == keys.size() - 1 ? ret + key + "=" + value : ret + key + "=" + value + "&";
        }
        return ret;
    }
}

