/*
 * Decompiled with CFR 0.152.
 */
package com.rui.alphaplayer;

import android.arch.lifecycle.LifecycleOwner;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.rui.alphaplayer.AlphaPlayer;
import com.rui.alphaplayer.R;
import com.rui.alphaplayer.bean.MyAlphaAdConfigModel;
import com.rui.alphaplayer.callback.IMyMonitor;
import com.rui.alphaplayer.callback.IMyPlayerAction;
import com.rui.alphaplayer.utils.MyAlphaAdJsonUtils;
import com.ss.ugc.android.alpha_player.IMonitor;
import com.ss.ugc.android.alpha_player.IPlayerAction;
import com.ss.ugc.android.alpha_player.controller.PlayerController;
import com.ss.ugc.android.alpha_player.model.AlphaVideoViewType;
import com.ss.ugc.android.alpha_player.model.Configuration;
import com.ss.ugc.android.alpha_player.model.DataSource;
import com.ss.ugc.android.alpha_player.model.ScaleType;
import com.ss.ugc.android.alpha_player.player.IMediaPlayer;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class AlphaPlayerView
extends FrameLayout {
    private static final String TAG = "AlphaPlayerView";
    private Context mContext;
    private RelativeLayout mVideoContainer;
    private AlphaVideoViewType mViewType = AlphaVideoViewType.GL_SURFACE_VIEW;
    private PlayerController mPlayerController;
    private Configuration mPlayConfiguration;
    private boolean mEnableMediaCodec = false;
    private AlphaPlayer mAlphaPlayer;
    private IMyPlayerAction mIPlayerAction;
    private IMyMonitor mIMonitor;
    private IPlayerAction playerAction = new IPlayerAction(){

        public void onVideoSizeChanged(int i, int i1, @NotNull ScaleType scaleType) {
            if (AlphaPlayerView.this.mIPlayerAction != null) {
                AlphaPlayerView.this.mIPlayerAction.onVideoSizeChanged(i, i1);
            }
        }

        public void startAction() {
            if (AlphaPlayerView.this.mIPlayerAction != null) {
                AlphaPlayerView.this.mIPlayerAction.startAction();
            }
        }

        public void endAction() {
            if (AlphaPlayerView.this.mIPlayerAction != null) {
                AlphaPlayerView.this.mIPlayerAction.endAction();
            }
        }
    };
    private IMonitor monitor = new IMonitor(){

        public void monitor(boolean b, @NotNull String s, int i, int i1, @NotNull String s1) {
            if (AlphaPlayerView.this.mIMonitor != null) {
                AlphaPlayerView.this.mIMonitor.monitor(b, s, i, i1, s1);
            }
        }
    };

    public AlphaPlayerView(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public AlphaPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
    }

    public AlphaPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
    }

    public void initView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.view_player, (ViewGroup)this);
        this.mVideoContainer = (RelativeLayout)this.findViewById(R.id.alpha_play_view);
        this.mAlphaPlayer = new AlphaPlayer(this.mContext);
    }

    public void initController(LifecycleOwner lifecycleOwner) {
        if (this.mPlayConfiguration == null) {
            this.mPlayConfiguration = new Configuration(this.mContext, lifecycleOwner);
            this.mPlayConfiguration.setAlphaVideoViewType(this.mViewType);
        }
        if (this.mPlayerController == null && this.mAlphaPlayer != null) {
            this.mAlphaPlayer.setEnableMediaCodec(this.mEnableMediaCodec);
            this.mPlayerController = new PlayerController(this.mContext, lifecycleOwner, this.mPlayConfiguration.getAlphaVideoViewType(), (IMediaPlayer)this.mAlphaPlayer);
            if (this.mIMonitor != null) {
                this.mPlayerController.setMonitor(this.monitor);
            }
            if (this.mIPlayerAction != null) {
                this.mPlayerController.setPlayerAction(this.playerAction);
            }
        }
    }

    public void play(String videoPath) {
        if (TextUtils.isEmpty((CharSequence)videoPath)) {
            Log.e((String)TAG, (String)"videopath is null");
            return;
        }
        File dirFile = new File(videoPath);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        this.attachPlayView();
        MyAlphaAdConfigModel configModel = MyAlphaAdJsonUtils.parseConfigModel(dirFile.getAbsolutePath());
        DataSource mDataSource = new DataSource();
        mDataSource.baseDir = videoPath;
        mDataSource.setPortraitPath(configModel.getPortraitItem().getPath(), configModel.getPortraitItem().getAlignMode());
        mDataSource.setLandscapePath(configModel.getLandscapeItem().getPath(), configModel.getLandscapeItem().getAlignMode());
        if (mDataSource.isValid()) {
            this.mPlayerController.start(mDataSource);
        }
    }

    public void attachPlayView() {
        if (this.mPlayerController != null) {
            this.mPlayerController.attachAlphaView((ViewGroup)this.mVideoContainer);
        }
    }

    public void detachPlayView() {
        if (this.mPlayerController != null) {
            this.mPlayerController.detachAlphaView((ViewGroup)this.mVideoContainer);
        }
    }

    public void releasePlayController() {
        if (this.mPlayerController != null) {
            this.detachPlayView();
            this.mPlayerController.release();
        }
    }

    public AlphaVideoViewType getViewType() {
        return this.mViewType;
    }

    public void setViewType(AlphaVideoViewType mViewType) {
        this.mViewType = mViewType;
    }

    public boolean isEnableMediaCodec() {
        return this.mEnableMediaCodec;
    }

    public void setEnableMediaCodec(boolean mEnableMediaCodec) {
        this.mEnableMediaCodec = mEnableMediaCodec;
    }

    public void setPlayerAction(IMyPlayerAction mIPlayerAction) {
        this.mIPlayerAction = mIPlayerAction;
    }

    public void setMonitor(IMyMonitor mIMonitor) {
        this.mIMonitor = mIMonitor;
    }
}

