/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.georss.geometries;

import com.rometools.modules.georss.geometries.AbstractRing;
import com.rometools.modules.georss.geometries.AbstractSurface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Polygon
extends AbstractSurface {
    private static final long serialVersionUID = 1L;
    private AbstractRing exterior;
    private List<AbstractRing> interior;

    @Override
    public Object clone() throws CloneNotSupportedException {
        Polygon retval = (Polygon)super.clone();
        if (this.exterior != null) {
            retval.exterior = (AbstractRing)this.exterior.clone();
        }
        if (this.interior != null) {
            retval.interior = new ArrayList<AbstractRing>();
            for (AbstractRing r : this.interior) {
                retval.interior.add((AbstractRing)r.clone());
            }
        }
        return retval;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Polygon pol = (Polygon)obj;
        if (this.exterior != null || pol.exterior != null) {
            if (this.exterior == null || pol.exterior == null) {
                return false;
            }
            if (!this.exterior.equals(pol.exterior)) {
                return false;
            }
        }
        Iterator<AbstractRing> it = this.interior.iterator();
        while (it.hasNext()) {
            if (pol.interior.contains(it.next())) continue;
            return false;
        }
        it = pol.interior.iterator();
        while (it.hasNext()) {
            if (this.interior.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public AbstractRing getExterior() {
        return this.exterior;
    }

    public List<AbstractRing> getInterior() {
        if (this.interior == null) {
            this.interior = new ArrayList<AbstractRing>();
        }
        return this.interior;
    }

    public void setExterior(AbstractRing exterior) {
        this.exterior = exterior;
    }

    public void setInterior(List<AbstractRing> interior) {
        this.interior = interior;
    }
}

