/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.itunes.types;

import com.rometools.rome.io.impl.NumberParser;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class Duration
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final NumberFormat NUM_FORMAT = NumberFormat.getNumberInstance();
    private long milliseconds;

    public Duration() {
    }

    public Duration(long milliseconds) {
        this.setMilliseconds(milliseconds);
    }

    public Duration(int hours, int minutes, float seconds) {
        this.setMilliseconds((long)hours * 3600000L + (long)minutes * 60000L + (long)(seconds * 1000.0f));
    }

    public Duration(String duration) {
        StringTokenizer tok = new StringTokenizer(duration, ":");
        switch (tok.countTokens()) {
            case 1: {
                this.setMilliseconds((long)(NumberParser.parseFloat((String)tok.nextToken(), (float)0.0f) * 1000.0f));
                break;
            }
            case 2: {
                this.setMilliseconds(NumberParser.parseLong((String)tok.nextToken(), (long)0L) * 60000L + (long)(NumberParser.parseFloat((String)tok.nextToken(), (float)0.0f) * 1000.0f));
                break;
            }
            case 3: {
                this.setMilliseconds(NumberParser.parseLong((String)tok.nextToken(), (long)0L) * 3600000L + NumberParser.parseLong((String)tok.nextToken(), (long)0L) * 60000L + (long)(NumberParser.parseFloat((String)tok.nextToken(), (float)0.0f) * 1000.0f));
                break;
            }
            default: {
                throw new RuntimeException("Illegal time value: " + duration);
            }
        }
    }

    public String toString() {
        Time time = new Time();
        return NUM_FORMAT.format(time.hours) + ":" + NUM_FORMAT.format(time.minutes) + ":" + NUM_FORMAT.format(Math.round(time.seconds));
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    static {
        NUM_FORMAT.setMinimumFractionDigits(0);
        NUM_FORMAT.setMaximumFractionDigits(0);
        NUM_FORMAT.setMinimumIntegerDigits(2);
        NUM_FORMAT.setGroupingUsed(false);
    }

    private class Time {
        int hours;
        int minutes;
        float seconds;

        public Time() {
            long time = Duration.this.getMilliseconds();
            this.hours = (int)(time / 3600000L);
            this.minutes = (int)((time -= (long)this.hours * 3600000L) / 60000L);
            this.seconds = (float)(time -= (long)this.minutes * 60000L) / 1000.0f;
        }
    }
}

