/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.opensearch.impl;

import com.rometools.modules.opensearch.OpenSearchModule;
import com.rometools.modules.opensearch.RequiredAttributeMissingException;
import com.rometools.modules.opensearch.entity.OSQuery;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class OpenSearchModuleGenerator
implements ModuleGenerator {
    private static final Namespace OS_NS = Namespace.getNamespace((String)"opensearch", (String)"http://a9.com/-/spec/opensearch/1.1/");
    private static final Set<Namespace> NAMESPACES;

    public String getNamespaceUri() {
        return "http://a9.com/-/spec/opensearch/1.1/";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        OpenSearchModule osm = (OpenSearchModule)module;
        if (osm.getItemsPerPage() > -1) {
            element.addContent((Content)this.generateSimpleElement("itemsPerPage", Integer.toString(osm.getItemsPerPage())));
        }
        if (osm.getTotalResults() > -1) {
            element.addContent((Content)this.generateSimpleElement("totalResults", Integer.toString(osm.getTotalResults())));
        }
        int startIndex = osm.getStartIndex() > 0 ? osm.getStartIndex() : 1;
        element.addContent((Content)this.generateSimpleElement("startIndex", Integer.toString(startIndex)));
        if (osm.getQueries() != null) {
            List queries = osm.getQueries();
            for (OSQuery query : queries) {
                if (query == null) continue;
                element.addContent((Content)this.generateQueryElement(query));
            }
        }
        if (osm.getLink() != null) {
            element.addContent((Content)this.generateLinkElement(osm.getLink()));
        }
    }

    protected Element generateQueryElement(OSQuery query) {
        Element qElement = new Element("Query", OS_NS);
        if (query.getRole() == null) {
            throw new RequiredAttributeMissingException("If declaring a Query element, the field 'role' must be be specified");
        }
        Attribute roleAttribute = new Attribute("role", query.getRole());
        qElement.setAttribute(roleAttribute);
        if (query.getOsd() != null) {
            Attribute osd = new Attribute("osd", query.getOsd());
            qElement.setAttribute(osd);
        }
        if (query.getSearchTerms() != null) {
            Attribute searchTerms = new Attribute("searchTerms", query.getSearchTerms());
            qElement.setAttribute(searchTerms);
        }
        if (query.getStartPage() > -1) {
            int startPage = query.getStartPage() != 0 ? query.getStartPage() : 1;
            Attribute sp = new Attribute("startPage", Integer.toString(startPage));
            qElement.setAttribute(sp);
        }
        if (query.getTitle() != null) {
            qElement.setAttribute(new Attribute("title", query.getTitle()));
        }
        if (query.getTotalResults() > -1) {
            qElement.setAttribute(new Attribute("totalResults", Integer.toString(query.getTotalResults())));
        }
        return qElement;
    }

    protected Element generateLinkElement(Link link) {
        Element linkElement = new Element("link", OS_NS);
        if (link.getRel() != null) {
            Attribute relAttribute = new Attribute("rel", "search");
            linkElement.setAttribute(relAttribute);
        }
        if (link.getType() != null) {
            Attribute typeAttribute = new Attribute("type", link.getType());
            linkElement.setAttribute(typeAttribute);
        }
        if (link.getHref() != null) {
            Attribute hrefAttribute = new Attribute("href", link.getHref());
            linkElement.setAttribute(hrefAttribute);
        }
        if (link.getHreflang() != null) {
            Attribute hreflangAttribute = new Attribute("hreflang", link.getHreflang());
            linkElement.setAttribute(hreflangAttribute);
        }
        return linkElement;
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, OS_NS);
        element.addContent(value);
        return element;
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(OS_NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

