/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.opensearch.impl;

import com.rometools.modules.opensearch.OpenSearchModule;
import com.rometools.modules.opensearch.entity.OSQuery;
import com.rometools.rome.feed.CopyFrom;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.module.ModuleImpl;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class OpenSearchModuleImpl
extends ModuleImpl
implements OpenSearchModule,
Serializable {
    private static final long serialVersionUID = 1L;
    private int totalResults = -1;
    private int startIndex = 1;
    private int itemsPerPage = -1;
    private Link link;
    private List<OSQuery> queries;

    public OpenSearchModuleImpl() {
        super(OpenSearchModuleImpl.class, "http://a9.com/-/spec/opensearch/1.1/");
    }

    @Override
    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    @Override
    public Link getLink() {
        return this.link;
    }

    @Override
    public void setLink(Link link) {
        this.link = link;
    }

    @Override
    public List<OSQuery> getQueries() {
        if (this.queries == null) {
            this.queries = new LinkedList<OSQuery>();
        }
        return this.queries;
    }

    @Override
    public void setQueries(List<OSQuery> queries) {
        this.queries = queries;
    }

    @Override
    public void addQuery(OSQuery query) {
        this.getQueries().add(query);
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    @Override
    public int getTotalResults() {
        return this.totalResults;
    }

    @Override
    public void setTotalResults(int totalResults) {
        this.totalResults = totalResults;
    }

    public void copyFrom(CopyFrom obj) {
        OpenSearchModule osm = (OpenSearchModule)obj;
        this.setTotalResults(osm.getTotalResults());
        this.setItemsPerPage(osm.getItemsPerPage());
        this.setStartIndex(osm.getStartIndex());
        this.setLink(osm.getLink());
        for (OSQuery q : osm.getQueries()) {
            try {
                this.getQueries().add((OSQuery)q.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public Class<OpenSearchModule> getInterface() {
        return OpenSearchModule.class;
    }
}

