/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.mediarss.types;

import com.rometools.modules.mediarss.types.MediaContent;
import com.rometools.modules.mediarss.types.Metadata;
import com.rometools.rome.feed.impl.EqualsBean;
import com.rometools.rome.feed.impl.ToStringBean;
import java.io.Serializable;

public class MediaGroup
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Integer defaultContentIndex;
    private Metadata metadata;
    private MediaContent[] contents = new MediaContent[0];

    public MediaGroup(MediaContent[] contents) {
        this.setContents(contents);
    }

    public MediaGroup(MediaContent[] contents, Integer defaultContentIndex) {
        this.setContents(contents);
        this.setDefaultContentIndex(defaultContentIndex);
    }

    public MediaGroup(MediaContent[] contents, Integer defaultContentIndex, Metadata metadata) {
        this.setContents(contents);
        this.setDefaultContentIndex(defaultContentIndex);
        this.setMetadata(metadata);
    }

    public void setContents(MediaContent[] contents) {
        this.contents = contents == null ? new MediaContent[]{} : contents;
    }

    public MediaContent[] getContents() {
        return this.contents;
    }

    public void setDefaultContentIndex(Integer defaultContentIndex) {
        for (int i = 0; i < this.getContents().length; ++i) {
            if (i == defaultContentIndex) {
                this.getContents()[i].setDefaultContent(true);
                continue;
            }
            this.getContents()[i].setDefaultContent(false);
        }
        this.defaultContentIndex = defaultContentIndex;
    }

    public Integer getDefaultContentIndex() {
        return this.defaultContentIndex;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Object clone() {
        return new MediaGroup(this.getContents(), this.getDefaultContentIndex(), this.getMetadata());
    }

    public boolean equals(Object obj) {
        EqualsBean eBean = new EqualsBean(this.getClass(), (Object)this);
        return eBean.beanEquals(obj);
    }

    public int hashCode() {
        EqualsBean equals = new EqualsBean(this.getClass(), (Object)this);
        return equals.beanHashCode();
    }

    public String toString() {
        ToStringBean tsBean = new ToStringBean(this.getClass(), (Object)this);
        return tsBean.toString();
    }
}

