/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.feedpress.io;

import com.rometools.modules.feedpress.modules.FeedpressModule;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class FeedpressGenerator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"feedpress", (String)"https://feed.press/xmlns");
    private static final Set<Namespace> NAMESPACES;

    public String getNamespaceUri() {
        return "https://feed.press/xmlns";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        if (module instanceof FeedpressModule) {
            FeedpressModule feedpress = (FeedpressModule)module;
            this.generateNewsletterId(feedpress.getNewsletterId(), element);
            this.generateLocale(feedpress.getLocale(), element);
            this.generatePodcastId(feedpress.getPodcastId(), element);
            this.generateCssFile(feedpress.getCssFile(), element);
        }
    }

    private void generateNewsletterId(String newsletterId, Element parent) {
        Element child = new Element("newsletterId", NS);
        child.setText(newsletterId);
        parent.addContent((Content)child);
    }

    private void generateLocale(String locale, Element parent) {
        Element child = new Element("locale", NS);
        child.setText(locale);
        parent.addContent((Content)child);
    }

    private void generatePodcastId(String podcastId, Element parent) {
        Element child = new Element("podcastId", NS);
        child.setText(podcastId);
        parent.addContent((Content)child);
    }

    private void generateCssFile(String cssFile, Element parent) {
        Element child = new Element("cssFile", NS);
        child.setText(cssFile);
        parent.addContent((Content)child);
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

