/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.base.io;

import com.rometools.modules.base.GoogleBaseImpl;
import com.rometools.modules.base.io.GoogleBaseParser;
import com.rometools.modules.base.types.CurrencyEnumeration;
import com.rometools.modules.base.types.DateTimeRange;
import com.rometools.modules.base.types.FloatUnit;
import com.rometools.modules.base.types.GenderEnumeration;
import com.rometools.modules.base.types.IntUnit;
import com.rometools.modules.base.types.PaymentTypeEnumeration;
import com.rometools.modules.base.types.PriceTypeEnumeration;
import com.rometools.modules.base.types.ShippingType;
import com.rometools.modules.base.types.ShortDate;
import com.rometools.modules.base.types.Size;
import com.rometools.modules.base.types.YearType;
import com.rometools.rome.feed.impl.PropertyDescriptor;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBaseGenerator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"g-core", (String)"http://base.google.com/ns/1.0");
    private static final Logger LOG = LoggerFactory.getLogger(GoogleBaseGenerator.class);

    public String getNamespaceUri() {
        return "http://base.google.com/ns/1.0";
    }

    public Set<Namespace> getNamespaces() {
        HashSet<Namespace> set = new HashSet<Namespace>();
        set.add(NS);
        return set;
    }

    public void generate(Module module, Element element) {
        GoogleBaseImpl mod = (GoogleBaseImpl)module;
        HashMap<Object, Object> props2tags = new HashMap<Object, Object>(GoogleBaseParser.PROPS2TAGS);
        List<PropertyDescriptor> pds = GoogleBaseParser.pds;
        for (PropertyDescriptor pd : pds) {
            String tagName = (String)props2tags.get(pd.getName());
            if (tagName == null) continue;
            Object[] values = null;
            try {
                values = pd.getPropertyType().isArray() ? (Object[])pd.getReadMethod().invoke((Object)mod, (Object[])null) : new Object[]{pd.getReadMethod().invoke((Object)mod, (Object[])null)};
                for (int j = 0; values != null && j < values.length; ++j) {
                    if (values[j] == null) continue;
                    element.addContent((Content)this.generateTag(values[j], tagName));
                }
            }
            catch (Exception e) {
                LOG.error("Error", (Throwable)e);
            }
        }
    }

    public Element generateTag(Object o, String tagName) {
        if (o instanceof URL || o instanceof Float || o instanceof Boolean || o instanceof Integer || o instanceof String || o instanceof FloatUnit || o instanceof IntUnit || o instanceof GenderEnumeration || o instanceof PaymentTypeEnumeration || o instanceof PriceTypeEnumeration || o instanceof CurrencyEnumeration || o instanceof Size || o instanceof YearType) {
            return this.generateSimpleElement(tagName, o.toString());
        }
        if (o instanceof ShortDate) {
            return this.generateSimpleElement(tagName, GoogleBaseParser.SHORT_DT_FMT.format(o));
        }
        if (o instanceof Date) {
            return this.generateSimpleElement(tagName, GoogleBaseParser.LONG_DT_FMT.format(o));
        }
        if (o instanceof ShippingType) {
            ShippingType st = (ShippingType)o;
            Element element = new Element(tagName, NS);
            element.addContent((Content)this.generateSimpleElement("country", st.getCountry()));
            element.addContent((Content)this.generateSimpleElement("service", st.getService().toString()));
            element.addContent((Content)this.generateSimpleElement("price", st.getPrice().toString()));
            return element;
        }
        if (o instanceof DateTimeRange) {
            DateTimeRange dtr = (DateTimeRange)o;
            Element element = new Element(tagName, NS);
            element.addContent((Content)this.generateSimpleElement("start", GoogleBaseParser.LONG_DT_FMT.format(dtr.getStart())));
            element.addContent((Content)this.generateSimpleElement("end", GoogleBaseParser.LONG_DT_FMT.format(dtr.getEnd())));
            return element;
        }
        throw new RuntimeException("Unknown class type to handle: " + o.getClass().getName());
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }
}

