/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.yahooweather.io;

import com.rometools.modules.yahooweather.YWeatherModuleImpl;
import com.rometools.modules.yahooweather.types.Astronomy;
import com.rometools.modules.yahooweather.types.Atmosphere;
import com.rometools.modules.yahooweather.types.Condition;
import com.rometools.modules.yahooweather.types.ConditionCode;
import com.rometools.modules.yahooweather.types.Forecast;
import com.rometools.modules.yahooweather.types.Location;
import com.rometools.modules.yahooweather.types.Units;
import com.rometools.modules.yahooweather.types.Wind;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherModuleParser
implements ModuleParser {
    private static final Logger LOG = LoggerFactory.getLogger(WeatherModuleParser.class);
    private static final Namespace NS = Namespace.getNamespace((String)"http://xml.weather.yahoo.com/ns/rss/1.0");

    public String getNamespaceUri() {
        return "http://xml.weather.yahoo.com/ns/rss/1.0";
    }

    public Module parse(Element element, Locale locale) {
        List forecasts;
        Element condition;
        Element astronomy;
        Element atmosphere;
        Element wind;
        Element units;
        YWeatherModuleImpl module = new YWeatherModuleImpl();
        Element location = element.getChild("location", NS);
        if (location != null) {
            Location l = new Location(location.getAttributeValue("city"), location.getAttributeValue("region"), location.getAttributeValue("country"));
            module.setLocation(l);
        }
        if ((units = element.getChild("units", NS)) != null) {
            Units u = new Units(units.getAttributeValue("temperature"), units.getAttributeValue("distance"), units.getAttributeValue("pressure"), units.getAttributeValue("speed"));
            module.setUnits(u);
        }
        if ((wind = element.getChild("wind", NS)) != null) {
            try {
                Wind w = new Wind(Integer.parseInt(wind.getAttributeValue("chill")), Integer.parseInt(wind.getAttributeValue("direction")), Integer.parseInt(wind.getAttributeValue("speed")));
                module.setWind(w);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("NumberFormatException processing <wind> tag.", (Throwable)nfe);
            }
        }
        if ((atmosphere = element.getChild("atmosphere", NS)) != null) {
            try {
                Atmosphere a = new Atmosphere(Integer.parseInt(atmosphere.getAttributeValue("humidity")), Double.parseDouble(atmosphere.getAttributeValue("visibility")) / 100.0, Double.parseDouble(atmosphere.getAttributeValue("pressure")), Atmosphere.PressureChange.fromCode(Integer.parseInt(atmosphere.getAttributeValue("rising"))));
                module.setAtmosphere(a);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("NumberFormatException processing <atmosphere> tag.", (Throwable)nfe);
            }
        }
        if ((astronomy = element.getChild("astronomy", NS)) != null) {
            try {
                SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm a", locale);
                Astronomy a = new Astronomy(timeFormat.parse(astronomy.getAttributeValue("sunrise").replaceAll("am", "AM").replaceAll("pm", "PM")), timeFormat.parse(astronomy.getAttributeValue("sunset").replaceAll("am", "AM").replaceAll("pm", "PM")));
                module.setAstronomy(a);
            }
            catch (ParseException pe) {
                LOG.warn("ParseException processing <astronomy> tag.", (Throwable)pe);
            }
        }
        if ((condition = element.getChild("condition", NS)) != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy h:mm a zzz", locale);
                Condition c = new Condition(condition.getAttributeValue("text"), ConditionCode.fromCode(Integer.parseInt(condition.getAttributeValue("code"))), Integer.parseInt(condition.getAttributeValue("temp")), dateFormat.parse(condition.getAttributeValue("date").replaceAll("pm", "PM").replaceAll("am", "AM")));
                module.setCondition(c);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("NumberFormatException processing <condition> tag.", (Throwable)nfe);
            }
            catch (ParseException pe) {
                LOG.warn("ParseException processing <condition> tag.", (Throwable)pe);
            }
        }
        if ((forecasts = element.getChildren("forecast", NS)) != null) {
            Forecast[] f = new Forecast[forecasts.size()];
            int i = 0;
            SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy", locale);
            for (Element forecast : forecasts) {
                try {
                    f[i] = new Forecast(forecast.getAttributeValue("day"), dateFormat.parse(forecast.getAttributeValue("date")), Integer.parseInt(forecast.getAttributeValue("low")), Integer.parseInt(forecast.getAttributeValue("high")), forecast.getAttributeValue("text"), ConditionCode.fromCode(Integer.parseInt(forecast.getAttributeValue("code"))));
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("NumberFormatException processing <forecast> tag.", (Throwable)nfe);
                }
                catch (ParseException pe) {
                    LOG.warn("ParseException processing <forecast> tag.", (Throwable)pe);
                }
                ++i;
            }
            module.setForecasts(f);
        }
        return module;
    }
}

