/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.base.io;

import com.rometools.modules.base.CustomTag;
import com.rometools.modules.base.CustomTagImpl;
import com.rometools.modules.base.CustomTags;
import com.rometools.modules.base.io.CustomTagParser;
import com.rometools.modules.base.io.GoogleBaseParser;
import com.rometools.modules.base.types.DateTimeRange;
import com.rometools.modules.base.types.FloatUnit;
import com.rometools.modules.base.types.IntUnit;
import com.rometools.modules.base.types.ShortDate;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CustomTagGenerator
implements ModuleGenerator {
    static final HashSet<Namespace> NAMESPACES = new HashSet();

    public String getNamespaceUri() {
        return "http://base.google.com/cns/1.0";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        if (!(module instanceof CustomTags)) {
            return;
        }
        List<CustomTag> tags = ((CustomTags)module).getValues();
        for (CustomTag tag : tags) {
            Element newTag;
            Element newTag2;
            if (tag.getValue() instanceof DateTimeRange) {
                DateTimeRange dtr = (DateTimeRange)tag.getValue();
                newTag2 = new Element(tag.getName(), CustomTagParser.NS);
                newTag2.setAttribute("type", "dateTimeRange");
                newTag2.addContent((Content)this.generateSimpleElement("start", GoogleBaseParser.LONG_DT_FMT.format(dtr.getStart())));
                newTag2.addContent((Content)this.generateSimpleElement("end", GoogleBaseParser.LONG_DT_FMT.format(dtr.getEnd())));
                element.addContent((Content)newTag2);
                continue;
            }
            if (tag.getValue() instanceof ShortDate) {
                ShortDate sd = (ShortDate)tag.getValue();
                newTag2 = this.generateSimpleElement(tag.getName(), GoogleBaseParser.SHORT_DT_FMT.format(sd));
                newTag2.setAttribute("type", "date");
                element.addContent((Content)newTag2);
                continue;
            }
            if (tag.getValue() instanceof Date) {
                Date d = (Date)tag.getValue();
                newTag2 = this.generateSimpleElement(tag.getName(), GoogleBaseParser.SHORT_DT_FMT.format(d));
                newTag2.setAttribute("type", "dateTime");
                element.addContent((Content)newTag2);
                continue;
            }
            if (tag.getValue() instanceof Integer) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "int");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof IntUnit) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "intUnit");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof Float) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "float");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof FloatUnit) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "floatUnit");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof String) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "string");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof URL) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "url");
                element.addContent((Content)newTag);
                continue;
            }
            if (tag.getValue() instanceof Boolean) {
                newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
                newTag.setAttribute("type", "boolean");
                element.addContent((Content)newTag);
                continue;
            }
            if (!(tag.getValue() instanceof CustomTagImpl.Location)) continue;
            newTag = this.generateSimpleElement(tag.getName(), tag.getValue().toString());
            newTag.setAttribute("type", "location");
            element.addContent((Content)newTag);
        }
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, CustomTagParser.NS);
        element.addContent(value);
        return element;
    }

    static {
        NAMESPACES.add(CustomTagParser.NS);
    }
}

