/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.cc.io;

import com.rometools.modules.cc.CreativeCommons;
import com.rometools.modules.cc.types.License;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCModuleGenerator
implements ModuleGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CCModuleGenerator.class);
    private static final Namespace RSS1 = Namespace.getNamespace((String)"cc", (String)"http://web.resource.org/cc/");
    private static final Namespace RSS2 = Namespace.getNamespace((String)"creativeCommons", (String)"http://backend.userland.com/creativeCommonsRssModule");
    private static final Namespace RSS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");
    private static final Namespace RDF = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    private static final HashSet<Namespace> NAMESPACES = new HashSet();

    public void generate(Module module, Element element) {
        Element root = element;
        while (root.getParentElement() != null) {
            root = root.getParentElement();
        }
        if (root.getNamespace().equals((Object)RDF) || root.getNamespace().equals((Object)RSS)) {
            this.generateRSS1((CreativeCommons)module, element);
        } else {
            this.generateRSS2((CreativeCommons)module, element);
        }
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public String getNamespaceUri() {
        return "rome:CreativeCommons";
    }

    private void generateRSS1(CreativeCommons module, Element element) {
        Element license;
        LOG.debug(element.getName());
        if (element.getName().equals("channel")) {
            License[] all;
            for (License element2 : all = module.getAllLicenses()) {
                license = new Element("License", RSS1);
                license.setAttribute("about", element2.getValue(), RDF);
                License.Behaviour[] permits = element2.getPermits();
                for (int j = 0; permits != null && j < permits.length; ++j) {
                    Element permit = new Element("permits", RSS1);
                    permit.setAttribute("resource", permits[j].toString(), RDF);
                    license.addContent((Content)permit);
                }
                License.Behaviour[] requires = element2.getPermits();
                for (int j = 0; requires != null && j < requires.length; ++j) {
                    Element permit = new Element("requires", RSS1);
                    permit.setAttribute("resource", permits[j].toString(), RDF);
                    license.addContent((Content)permit);
                }
                LOG.debug("Is Root? {}", (Object)element.getParentElement());
                element.getParentElement().addContent((Content)license);
            }
        }
        License[] licenses = module.getLicenses();
        for (License license2 : licenses) {
            license = new Element("license", RSS1);
            license.setAttribute("resource", license2.getValue(), RDF);
            element.addContent((Content)license);
        }
    }

    private void generateRSS2(CreativeCommons module, Element element) {
        License[] licenses = module.getLicenses();
        for (int i = 0; licenses != null && i < licenses.length; ++i) {
            Element license = new Element("license", RSS2);
            license.setText(licenses[i].getValue());
            element.addContent((Content)license);
        }
    }

    static {
        NAMESPACES.add(RSS1);
        NAMESPACES.add(RSS2);
        NAMESPACES.add(RDF);
    }
}

