/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.sle;

import com.rometools.modules.sle.GroupStrategy;
import com.rometools.modules.sle.SortStrategy;
import com.rometools.modules.sle.SortableList;
import com.rometools.modules.sle.types.Group;
import com.rometools.modules.sle.types.Sort;
import com.rometools.rome.feed.CopyFrom;
import com.rometools.rome.feed.module.Extendable;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.SyndFeedOutput;
import java.util.List;
import org.jdom2.Document;

public final class SleUtility {
    private SleUtility() {
    }

    public static <T extends Extendable> List<T> group(List<T> values, Group[] groups) {
        SortableList<T> list = SleUtility.getSortableList(values);
        GroupStrategy strategy = new GroupStrategy();
        for (int i = groups.length - 1; i >= 0; --i) {
            list.sortOnProperty(groups[i], true, strategy);
        }
        return list;
    }

    public static <T extends Extendable> List<T> sort(List<T> values, Sort sort, boolean ascending) {
        SortableList<T> list = SleUtility.getSortableList(values);
        list.sortOnProperty(sort, ascending, new SortStrategy());
        return list;
    }

    public static <T extends Extendable> List<T> sortAndGroup(List<T> values, Group[] groups, Sort sort, boolean ascending) {
        List<T> list = SleUtility.sort(values, sort, ascending);
        list = SleUtility.group(list, groups);
        return list;
    }

    public static void initializeForSorting(SyndFeed feed) throws FeedException {
        SyndFeedOutput output = new SyndFeedOutput();
        Document document = output.outputJDom(feed);
        SyndFeed copy = new SyndFeedInput().build(document);
        feed.copyFrom((CopyFrom)copy);
    }

    private static <T extends Extendable> SortableList<T> getSortableList(List<T> list) {
        SortableList<T> sortableList = list instanceof SortableList ? (SortableList<T>)list : new SortableList<T>(list);
        return sortableList;
    }
}

