/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.mediarss.io;

import com.rometools.modules.georss.GMLGenerator;
import com.rometools.modules.mediarss.MediaEntryModule;
import com.rometools.modules.mediarss.MediaModule;
import com.rometools.modules.mediarss.types.Category;
import com.rometools.modules.mediarss.types.Credit;
import com.rometools.modules.mediarss.types.Embed;
import com.rometools.modules.mediarss.types.License;
import com.rometools.modules.mediarss.types.Location;
import com.rometools.modules.mediarss.types.MediaContent;
import com.rometools.modules.mediarss.types.MediaGroup;
import com.rometools.modules.mediarss.types.Metadata;
import com.rometools.modules.mediarss.types.PeerLink;
import com.rometools.modules.mediarss.types.PlayerReference;
import com.rometools.modules.mediarss.types.Price;
import com.rometools.modules.mediarss.types.Rating;
import com.rometools.modules.mediarss.types.Restriction;
import com.rometools.modules.mediarss.types.Scene;
import com.rometools.modules.mediarss.types.SubTitle;
import com.rometools.modules.mediarss.types.Tag;
import com.rometools.modules.mediarss.types.Text;
import com.rometools.modules.mediarss.types.Thumbnail;
import com.rometools.modules.mediarss.types.UrlReference;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MediaModuleGenerator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"media", (String)"http://search.yahoo.com/mrss/");
    private static final Set<Namespace> NAMESPACES = new HashSet<Namespace>();

    public String getNamespaceUri() {
        return "http://search.yahoo.com/mrss/";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        MediaModule m;
        if (module instanceof MediaModule) {
            m = (MediaModule)module;
            this.generateMetadata(m.getMetadata(), element);
            this.generatePlayer(m.getPlayer(), element);
        }
        if (module instanceof MediaEntryModule) {
            m = (MediaEntryModule)module;
            for (MediaGroup mediaGroup : m.getMediaGroups()) {
                this.generateGroup(mediaGroup, element);
            }
            for (Serializable serializable : m.getMediaContents()) {
                this.generateContent((MediaContent)serializable, element);
            }
        }
    }

    public void generateContent(MediaContent c, Element e) {
        Element mc = new Element("content", NS);
        this.addNotNullAttribute(mc, "medium", c.getMedium());
        this.addNotNullAttribute(mc, "channels", c.getAudioChannels());
        this.addNotNullAttribute(mc, "bitrate", c.getBitrate());
        this.addNotNullAttribute(mc, "duration", c.getDuration());
        this.addNotNullAttribute(mc, "expression", c.getExpression());
        this.addNotNullAttribute(mc, "fileSize", c.getFileSize());
        this.addNotNullAttribute(mc, "framerate", c.getFramerate());
        this.addNotNullAttribute(mc, "height", c.getHeight());
        this.addNotNullAttribute(mc, "lang", c.getLanguage());
        this.addNotNullAttribute(mc, "samplingrate", c.getSamplingrate());
        this.addNotNullAttribute(mc, "type", c.getType());
        this.addNotNullAttribute(mc, "width", c.getWidth());
        if (c.isDefaultContent()) {
            this.addNotNullAttribute(mc, "isDefault", "true");
        }
        if (c.getReference() instanceof UrlReference) {
            this.addNotNullAttribute(mc, "url", c.getReference());
            this.generatePlayer(c.getPlayer(), mc);
        } else {
            this.generatePlayer(c.getPlayer(), mc);
        }
        this.generateMetadata(c.getMetadata(), mc);
        e.addContent((Content)mc);
    }

    public void generateGroup(MediaGroup g, Element e) {
        MediaContent[] c;
        Element t = new Element("group", NS);
        for (MediaContent element : c = g.getContents()) {
            this.generateContent(element, t);
        }
        this.generateMetadata(g.getMetadata(), t);
        e.addContent((Content)t);
    }

    public void generateMetadata(Metadata m, Element e) {
        Restriction[] r;
        Text[] text;
        Rating[] rats;
        String[] keywords;
        Credit[] creds;
        Category[] cats;
        if (m == null) {
            return;
        }
        for (Category cat : cats = m.getCategories()) {
            Element c = this.generateSimpleElement("category", cat.getValue());
            this.addNotNullAttribute(c, "scheme", cat.getScheme());
            this.addNotNullAttribute(c, "label", cat.getLabel());
            e.addContent((Content)c);
        }
        Element copyright = this.addNotNullElement(e, "copyright", m.getCopyright());
        this.addNotNullAttribute(copyright, "url", m.getCopyrightUrl());
        for (Credit cred : creds = m.getCredits()) {
            Element c = this.generateSimpleElement("credit", cred.getName());
            this.addNotNullAttribute(c, "role", cred.getRole());
            this.addNotNullAttribute(c, "scheme", cred.getScheme());
            e.addContent((Content)c);
        }
        Element desc = this.addNotNullElement(e, "description", m.getDescription());
        this.addNotNullAttribute(desc, "type", m.getDescriptionType());
        if (m.getHash() != null) {
            Element hash = this.addNotNullElement(e, "hash", m.getHash().getValue());
            this.addNotNullAttribute(hash, "algo", m.getHash().getAlgorithm());
        }
        if ((keywords = m.getKeywords()).length > 0) {
            String keyword = keywords[0];
            for (int i = 1; i < keywords.length; ++i) {
                keyword = keyword + ", " + keywords[i];
            }
            this.addNotNullElement(e, "keywords", keyword);
        }
        for (Rating rat2 : rats = m.getRatings()) {
            Element rat = this.addNotNullElement(e, "rating", rat2.getValue());
            this.addNotNullAttribute(rat, "scheme", rat2.getScheme());
            if (rat2.equals(Rating.ADULT)) {
                this.addNotNullElement(e, "adult", "true");
                continue;
            }
            if (!rat2.equals(Rating.NONADULT)) continue;
            this.addNotNullElement(e, "adult", "false");
        }
        for (Text element : text = m.getText()) {
            Element t = this.addNotNullElement(e, "text", element.getValue());
            this.addNotNullAttribute(t, "type", element.getType());
            this.addNotNullAttribute(t, "start", element.getStart());
            this.addNotNullAttribute(t, "end", element.getEnd());
        }
        Element title = this.addNotNullElement(e, "title", m.getTitle());
        this.addNotNullAttribute(title, "type", m.getTitleType());
        this.generateBackLinks(m, e);
        this.generateComments(m, e);
        this.generateCommunity(m, e);
        this.generateEmbed(m, e);
        this.generateLicenses(m, e);
        this.generateLocations(m, e);
        this.generatePeerLinks(m, e);
        this.generatePrices(m, e);
        this.generateResponses(m, e);
        for (Restriction element : r = m.getRestrictions()) {
            Element res = this.addNotNullElement(e, "restriction", element.getValue());
            this.addNotNullAttribute(res, "type", element.getType());
            this.addNotNullAttribute(res, "relationship", element.getRelationship());
        }
        if (m.getRights() != null) {
            Element rights = new Element("rights", NS);
            rights.setAttribute("status", m.getRights().name());
            e.addContent((Content)rights);
        }
        this.generateScenes(m, e);
        this.generateStatus(m, e);
        this.generateSubTitles(m, e);
        this.generateThumbails(m, e);
    }

    private void generateThumbails(Metadata m, Element e) {
        for (Thumbnail thumb : m.getThumbnail()) {
            Element t = new Element("thumbnail", NS);
            this.addNotNullAttribute(t, "url", thumb.getUrl());
            this.addNotNullAttribute(t, "width", thumb.getWidth());
            this.addNotNullAttribute(t, "height", thumb.getHeight());
            this.addNotNullAttribute(t, "time", thumb.getTime());
            e.addContent((Content)t);
        }
    }

    private void generateBackLinks(Metadata m, Element e) {
        Element backLinksElements = new Element("backLinks", NS);
        for (URL backLink : m.getBackLinks()) {
            this.addNotNullElement(backLinksElements, "backLink", backLink);
        }
        if (!backLinksElements.getChildren().isEmpty()) {
            e.addContent((Content)backLinksElements);
        }
    }

    private void generateComments(Metadata m, Element e) {
        Element commentsElements = new Element("comments", NS);
        for (String comment : m.getComments()) {
            this.addNotNullElement(commentsElements, "comment", comment);
        }
        if (!commentsElements.getChildren().isEmpty()) {
            e.addContent((Content)commentsElements);
        }
    }

    private void generateCommunity(Metadata m, Element e) {
        if (m.getCommunity() == null) {
            return;
        }
        Element communityElement = new Element("community", NS);
        if (m.getCommunity().getStarRating() != null) {
            Element starRatingElement = new Element("starRating", NS);
            this.addNotNullAttribute(starRatingElement, "average", m.getCommunity().getStarRating().getAverage());
            this.addNotNullAttribute(starRatingElement, "count", m.getCommunity().getStarRating().getCount());
            this.addNotNullAttribute(starRatingElement, "min", m.getCommunity().getStarRating().getMin());
            this.addNotNullAttribute(starRatingElement, "max", m.getCommunity().getStarRating().getMax());
            if (starRatingElement.hasAttributes()) {
                communityElement.addContent((Content)starRatingElement);
            }
        }
        if (m.getCommunity().getStatistics() != null) {
            Element statisticsElement = new Element("statistics", NS);
            this.addNotNullAttribute(statisticsElement, "views", m.getCommunity().getStatistics().getViews());
            this.addNotNullAttribute(statisticsElement, "favorites", m.getCommunity().getStatistics().getFavorites());
            if (statisticsElement.hasAttributes()) {
                communityElement.addContent((Content)statisticsElement);
            }
        }
        if (m.getCommunity().getTags() != null && !m.getCommunity().getTags().isEmpty()) {
            Element tagsElement = new Element("tags", NS);
            for (Tag tag : m.getCommunity().getTags()) {
                if (!tagsElement.getTextTrim().isEmpty()) {
                    tagsElement.addContent(", ");
                }
                if (tag.getWeight() == null) {
                    tagsElement.addContent(tag.getName());
                    continue;
                }
                tagsElement.addContent(tag.getName());
                tagsElement.addContent(":");
                tagsElement.addContent(String.valueOf(tag.getWeight()));
            }
            if (!tagsElement.getTextTrim().isEmpty()) {
                communityElement.addContent((Content)tagsElement);
            }
        }
        if (!communityElement.getChildren().isEmpty()) {
            e.addContent((Content)communityElement);
        }
    }

    private void generateEmbed(Metadata m, Element e) {
        if (m.getEmbed() == null) {
            return;
        }
        Element embedElement = new Element("embed", NS);
        this.addNotNullAttribute(embedElement, "url", m.getEmbed().getUrl());
        this.addNotNullAttribute(embedElement, "width", m.getEmbed().getWidth());
        this.addNotNullAttribute(embedElement, "height", m.getEmbed().getHeight());
        for (Embed.Param param : m.getEmbed().getParams()) {
            Element paramElement = this.addNotNullElement(embedElement, "param", param.getValue());
            if (paramElement == null) continue;
            this.addNotNullAttribute(paramElement, "name", param.getName());
        }
        if (embedElement.hasAttributes() || !embedElement.getChildren().isEmpty()) {
            e.addContent((Content)embedElement);
        }
    }

    private void generateScenes(Metadata m, Element e) {
        Element scenesElement = new Element("scenes", NS);
        for (Scene scene : m.getScenes()) {
            Element sceneElement = new Element("scene", NS);
            this.addNotNullElement(sceneElement, "sceneTitle", scene.getTitle());
            this.addNotNullElement(sceneElement, "sceneDescription", scene.getDescription());
            this.addNotNullElement(sceneElement, "sceneStartTime", scene.getStartTime());
            this.addNotNullElement(sceneElement, "sceneEndTime", scene.getEndTime());
            if (sceneElement.getChildren().isEmpty()) continue;
            scenesElement.addContent((Content)sceneElement);
        }
        if (!scenesElement.getChildren().isEmpty()) {
            e.addContent((Content)scenesElement);
        }
    }

    private void generateLocations(Metadata m, Element e) {
        GMLGenerator geoRssGenerator = new GMLGenerator();
        for (Location location : m.getLocations()) {
            Element locationElement = new Element("location", NS);
            this.addNotNullAttribute(locationElement, "description", location.getDescription());
            this.addNotNullAttribute(locationElement, "start", location.getStart());
            this.addNotNullAttribute(locationElement, "end", location.getEnd());
            if (location.getGeoRss() != null) {
                geoRssGenerator.generate((Module)location.getGeoRss(), locationElement);
            }
            if (!locationElement.hasAttributes() && locationElement.getChildren().isEmpty()) continue;
            e.addContent((Content)locationElement);
        }
    }

    private void generatePeerLinks(Metadata m, Element e) {
        for (PeerLink peerLink : m.getPeerLinks()) {
            Element peerLinkElement = new Element("peerLink", NS);
            this.addNotNullAttribute(peerLinkElement, "type", peerLink.getType());
            this.addNotNullAttribute(peerLinkElement, "href", peerLink.getHref());
            if (!peerLinkElement.hasAttributes()) continue;
            e.addContent((Content)peerLinkElement);
        }
    }

    private void generateSubTitles(Metadata m, Element e) {
        for (SubTitle subTitle : m.getSubTitles()) {
            Element subTitleElement = new Element("subTitle", NS);
            this.addNotNullAttribute(subTitleElement, "type", subTitle.getType());
            this.addNotNullAttribute(subTitleElement, "lang", subTitle.getLang());
            this.addNotNullAttribute(subTitleElement, "href", subTitle.getHref());
            if (!subTitleElement.hasAttributes()) continue;
            e.addContent((Content)subTitleElement);
        }
    }

    private void generateLicenses(Metadata m, Element e) {
        for (License license : m.getLicenses()) {
            Element licenseElement = new Element("license", NS);
            this.addNotNullAttribute(licenseElement, "type", license.getType());
            this.addNotNullAttribute(licenseElement, "href", license.getHref());
            if (license.getValue() != null) {
                licenseElement.addContent(license.getValue());
            }
            if (!licenseElement.hasAttributes() && licenseElement.getTextTrim().isEmpty()) continue;
            e.addContent((Content)licenseElement);
        }
    }

    private void generatePrices(Metadata m, Element e) {
        for (Price price : m.getPrices()) {
            if (price == null) continue;
            Element priceElement = new Element("price", NS);
            if (price.getType() != null) {
                priceElement.setAttribute("type", price.getType().name().toLowerCase());
            }
            this.addNotNullAttribute(priceElement, "info", price.getInfo());
            this.addNotNullAttribute(priceElement, "price", price.getPrice());
            this.addNotNullAttribute(priceElement, "currency", price.getCurrency());
            if (!priceElement.hasAttributes()) continue;
            e.addContent((Content)priceElement);
        }
    }

    private void generateResponses(Metadata m, Element e) {
        if (m.getResponses() == null || m.getResponses().length == 0) {
            return;
        }
        Element responsesElements = new Element("responses", NS);
        for (String response : m.getResponses()) {
            this.addNotNullElement(responsesElements, "response", response);
        }
        e.addContent((Content)responsesElements);
    }

    private void generateStatus(Metadata m, Element e) {
        if (m.getStatus() == null) {
            return;
        }
        Element statusElement = new Element("status", NS);
        if (m.getStatus().getState() != null) {
            statusElement.setAttribute("state", m.getStatus().getState().name());
        }
        this.addNotNullAttribute(statusElement, "reason", m.getStatus().getReason());
        if (statusElement.hasAttributes()) {
            e.addContent((Content)statusElement);
        }
    }

    public void generatePlayer(PlayerReference p, Element e) {
        if (p == null) {
            return;
        }
        Element t = new Element("player", NS);
        this.addNotNullAttribute(t, "url", p.getUrl());
        this.addNotNullAttribute(t, "width", p.getWidth());
        this.addNotNullAttribute(t, "height", p.getHeight());
        e.addContent((Content)t);
    }

    protected void addNotNullAttribute(Element target, String name, Object value) {
        if (target == null || value == null) {
            return;
        }
        target.setAttribute(name, value.toString());
    }

    protected Element addNotNullElement(Element target, String name, Object value) {
        if (value == null) {
            return null;
        }
        Element e = this.generateSimpleElement(name, value.toString());
        target.addContent((Content)e);
        return e;
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }

    static {
        NAMESPACES.add(NS);
    }
}

