/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.georss;

import com.rometools.modules.georss.GMLModuleImpl;
import com.rometools.modules.georss.GeoRSSModule;
import com.rometools.modules.georss.geometries.Envelope;
import com.rometools.modules.georss.geometries.LineString;
import com.rometools.modules.georss.geometries.LinearRing;
import com.rometools.modules.georss.geometries.Point;
import com.rometools.modules.georss.geometries.Polygon;
import com.rometools.modules.georss.geometries.Position;
import com.rometools.modules.georss.geometries.PositionList;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import com.rometools.utils.Strings;
import java.util.List;
import java.util.Locale;
import org.jdom2.Element;

public class GMLParser
implements ModuleParser {
    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    public Module parse(Element element, Locale locale) {
        Module geoRssModule = GMLParser.parseGML(element);
        return geoRssModule;
    }

    private static PositionList parsePosList(Element element) {
        String coordinates = element.getText();
        String[] coord = Strings.trimToEmpty((String)coordinates).split("\\s+");
        PositionList posList = new PositionList();
        for (int i = 0; i < coord.length; i += 2) {
            try {
                posList.add(Double.parseDouble(coord[i]), Double.parseDouble(coord[i + 1]));
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return posList;
    }

    static Module parseGML(Element element) {
        GMLModuleImpl geoRSSModule = null;
        Element pointElement = element.getChild("Point", GeoRSSModule.GML_NS);
        Element lineStringElement = element.getChild("LineString", GeoRSSModule.GML_NS);
        Element polygonElement = element.getChild("Polygon", GeoRSSModule.GML_NS);
        Element envelopeElement = element.getChild("Envelope", GeoRSSModule.GML_NS);
        if (pointElement != null) {
            Element posElement = pointElement.getChild("pos", GeoRSSModule.GML_NS);
            if (posElement != null) {
                Position pos;
                geoRSSModule = new GMLModuleImpl();
                String coordinates = posElement.getText();
                String[] coord = Strings.trimToEmpty((String)coordinates).split("\\s+");
                try {
                    pos = new Position(Double.parseDouble(coord[0]), Double.parseDouble(coord[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
                geoRSSModule.setGeometry(new Point(pos));
            }
        } else if (lineStringElement != null) {
            Element posListElement = lineStringElement.getChild("posList", GeoRSSModule.GML_NS);
            if (posListElement != null) {
                geoRSSModule = new GMLModuleImpl();
                PositionList positionList = GMLParser.parsePosList(posListElement);
                if (positionList == null) {
                    return null;
                }
                geoRSSModule.setGeometry(new LineString(positionList));
            }
        } else if (polygonElement != null) {
            Element posListElement;
            Element linearRingElement;
            Polygon poly = null;
            Element exteriorElement = polygonElement.getChild("exterior", GeoRSSModule.GML_NS);
            if (exteriorElement != null && (linearRingElement = exteriorElement.getChild("LinearRing", GeoRSSModule.GML_NS)) != null && (posListElement = linearRingElement.getChild("posList", GeoRSSModule.GML_NS)) != null) {
                PositionList positionList;
                if (poly == null) {
                    poly = new Polygon();
                }
                if ((positionList = GMLParser.parsePosList(posListElement)) == null) {
                    return null;
                }
                poly.setExterior(new LinearRing(positionList));
            }
            List interiorElementList = polygonElement.getChildren("interior", GeoRSSModule.GML_NS);
            for (Element interiorElement : interiorElementList) {
                PositionList positionList;
                Element posListElement2;
                Element linearRingElement2;
                if (interiorElement == null || (linearRingElement2 = interiorElement.getChild("LinearRing", GeoRSSModule.GML_NS)) == null || (posListElement2 = linearRingElement2.getChild("posList", GeoRSSModule.GML_NS)) == null) continue;
                if (poly == null) {
                    poly = new Polygon();
                }
                if ((positionList = GMLParser.parsePosList(posListElement2)) == null) {
                    return null;
                }
                poly.getInterior().add(new LinearRing(positionList));
            }
            if (poly != null) {
                geoRSSModule = new GMLModuleImpl();
                geoRSSModule.setGeometry(poly);
            }
        } else if (envelopeElement != null) {
            Element lowerElement = envelopeElement.getChild("lowerCorner", GeoRSSModule.GML_NS);
            Element upperElement = envelopeElement.getChild("upperCorner", GeoRSSModule.GML_NS);
            if (lowerElement != null && upperElement != null) {
                Envelope envelope;
                geoRSSModule = new GMLModuleImpl();
                String lowerCoordinates = lowerElement.getText();
                String[] lowerCoord = Strings.trimToEmpty((String)lowerCoordinates).split("\\s+");
                String upperCoordinates = upperElement.getText();
                String[] upperCoord = Strings.trimToEmpty((String)upperCoordinates).split("\\s+");
                try {
                    envelope = new Envelope(Double.parseDouble(lowerCoord[0]), Double.parseDouble(lowerCoord[1]), Double.parseDouble(upperCoord[0]), Double.parseDouble(upperCoord[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
                geoRSSModule.setGeometry(envelope);
            }
        }
        return geoRSSModule;
    }
}

