/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.atom.io;

import com.rometools.modules.atom.modules.AtomLinkModule;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AtomModuleGenerator
implements ModuleGenerator {
    static final Namespace NS = Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom");
    private static final Set<Namespace> NAMESPACES;

    public final String getNamespaceUri() {
        return "http://www.w3.org/2005/Atom";
    }

    public final Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        if (module instanceof AtomLinkModule) {
            AtomLinkModule m = (AtomLinkModule)module;
            this.generateLinks(m.getLinks(), element);
        }
    }

    private Element generateLink(Link link) {
        Element linkElement = new Element("link", NS);
        if (link.getHref() != null) {
            Attribute href = new Attribute("href", link.getHref());
            linkElement.setAttribute(href);
        }
        if (link.getType() != null) {
            Attribute type = new Attribute("type", link.getType());
            linkElement.setAttribute(type);
        }
        if (link.getRel() != null) {
            Attribute rel = new Attribute("rel", link.getRel());
            linkElement.setAttribute(rel);
        }
        if (link.getHreflang() != null) {
            Attribute hreflangAttribute = new Attribute("hreflang", link.getHreflang());
            linkElement.setAttribute(hreflangAttribute);
        }
        if (link.getTitle() != null) {
            Attribute title = new Attribute("title", link.getTitle());
            linkElement.setAttribute(title);
        }
        if (link.getLength() != 0L) {
            Attribute length = new Attribute("length", Long.toString(link.getLength()));
            linkElement.setAttribute(length);
        }
        return linkElement;
    }

    private void generateLinks(List<Link> links, Element element) {
        for (Link link : links) {
            element.addContent((Content)this.generateLink(link));
        }
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

