/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.truncation;

import com.rollbar.api.payload.Payload;
import com.rollbar.notifier.sender.json.JsonSerializer;
import com.rollbar.notifier.truncation.FramesStrategy;
import com.rollbar.notifier.truncation.MinBodyStrategy;
import com.rollbar.notifier.truncation.StringsStrategy;
import com.rollbar.notifier.truncation.TruncationStrategy;
import com.rollbar.notifier.util.ObjectsUtils;
import java.nio.charset.Charset;

public class PayloadTruncator {
    private static final Charset TRANSPORT_CHARSET = Charset.forName("UTF-8");
    private static final TruncationStrategy[] STRATEGIES = new TruncationStrategy[]{new FramesStrategy(), new StringsStrategy(1024), new StringsStrategy(512), new StringsStrategy(256), new MinBodyStrategy()};
    private final JsonSerializer serializer;

    public PayloadTruncator(JsonSerializer serializer) {
        ObjectsUtils.requireNonNull(serializer, "serializer cannot be null");
        this.serializer = serializer;
    }

    public PayloadTruncationResult truncate(Payload payload, int maxSizeInBytes) {
        String json = this.serializer.toJson(payload);
        int currentSize = PayloadTruncator.sizeInBytes(json);
        for (int j = 0; currentSize > maxSizeInBytes && j < STRATEGIES.length; ++j) {
            TruncationStrategy.TruncationResult<Payload> result = STRATEGIES[j].truncate(payload);
            if (!result.wasTruncated) continue;
            payload = (Payload)result.value;
            json = this.serializer.toJson(payload);
            currentSize = PayloadTruncator.sizeInBytes(json);
        }
        return new PayloadTruncationResult(new Payload(json), currentSize);
    }

    public static int sizeInBytes(String payloadJsonString) {
        if (payloadJsonString == null) {
            return 0;
        }
        return payloadJsonString.getBytes(TRANSPORT_CHARSET).length;
    }

    public static final class PayloadTruncationResult {
        private final Payload payload;
        public final int finalSize;

        PayloadTruncationResult(Payload payload, int finalSize) {
            this.payload = payload;
            this.finalSize = finalSize;
        }

        public Payload getPayload() {
            return this.payload;
        }
    }
}

