/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.config;

import com.rollbar.api.payload.data.Client;
import com.rollbar.api.payload.data.Level;
import com.rollbar.api.payload.data.Notifier;
import com.rollbar.api.payload.data.Person;
import com.rollbar.api.payload.data.Request;
import com.rollbar.api.payload.data.Server;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.config.DefaultLevels;
import com.rollbar.notifier.filter.Filter;
import com.rollbar.notifier.fingerprint.FingerprintGenerator;
import com.rollbar.notifier.provider.Provider;
import com.rollbar.notifier.provider.notifier.NotifierProvider;
import com.rollbar.notifier.provider.timestamp.TimestampProvider;
import com.rollbar.notifier.sender.BufferedSender;
import com.rollbar.notifier.sender.Sender;
import com.rollbar.notifier.sender.SyncSender;
import com.rollbar.notifier.sender.json.JsonSerializer;
import com.rollbar.notifier.sender.json.JsonSerializerImpl;
import com.rollbar.notifier.transformer.Transformer;
import com.rollbar.notifier.uuid.UuidGenerator;
import java.net.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ConfigBuilder {
    protected String accessToken;
    protected String endpoint;
    protected String environment;
    protected String codeVersion;
    protected String platform;
    protected String language;
    protected String framework;
    protected Provider<String> context;
    protected Provider<Request> request;
    protected Provider<Person> person;
    protected Provider<Server> server;
    protected Provider<Client> client;
    protected Provider<Map<String, Object>> custom;
    protected Provider<Notifier> notifier;
    protected Provider<Long> timestamp;
    protected Filter filter;
    protected Transformer transformer;
    protected FingerprintGenerator fingerPrintGenerator;
    protected UuidGenerator uuidGenerator;
    protected Sender sender;
    protected JsonSerializer jsonSerializer = new JsonSerializerImpl();
    protected Proxy proxy;
    protected List<String> appPackages;
    protected boolean handleUncaughtErrors;
    protected boolean enabled;
    protected final DefaultLevels defaultLevels;
    protected boolean truncateLargePayloads;

    protected ConfigBuilder(String accessToken) {
        this.accessToken = accessToken;
        this.handleUncaughtErrors = true;
        this.enabled = true;
        this.defaultLevels = new DefaultLevels();
    }

    private ConfigBuilder(Config config) {
        this.accessToken = config.accessToken();
        this.environment = config.environment();
        this.codeVersion = config.codeVersion();
        this.platform = config.platform();
        this.language = config.language();
        this.framework = config.framework();
        this.context = config.context();
        this.request = config.request();
        this.person = config.person();
        this.server = config.server();
        this.client = config.client();
        this.custom = config.custom();
        this.notifier = config.notifier();
        this.timestamp = config.timestamp();
        this.filter = config.filter();
        this.transformer = config.transformer();
        this.fingerPrintGenerator = config.fingerPrintGenerator();
        this.uuidGenerator = config.uuidGenerator();
        this.sender = config.sender();
        this.handleUncaughtErrors = config.handleUncaughtErrors();
        this.enabled = config.isEnabled();
        this.endpoint = config.endpoint();
        this.jsonSerializer = config.jsonSerializer();
        this.proxy = config.proxy();
        this.appPackages = config.appPackages();
        this.defaultLevels = new DefaultLevels(config);
        this.truncateLargePayloads = config.truncateLargePayloads();
    }

    public static ConfigBuilder withAccessToken(String accessToken) {
        return new ConfigBuilder(accessToken);
    }

    public static ConfigBuilder withConfig(Config config) {
        return new ConfigBuilder(config);
    }

    public ConfigBuilder accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public ConfigBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ConfigBuilder environment(String environment) {
        this.environment = environment;
        return this;
    }

    public ConfigBuilder codeVersion(String codeVersion) {
        this.codeVersion = codeVersion;
        return this;
    }

    public ConfigBuilder platform(String platform) {
        this.platform = platform;
        return this;
    }

    public ConfigBuilder language(String language) {
        this.language = language;
        return this;
    }

    public ConfigBuilder framework(String framework) {
        this.framework = framework;
        return this;
    }

    public ConfigBuilder context(Provider<String> context) {
        this.context = context;
        return this;
    }

    public ConfigBuilder request(Provider<Request> request) {
        this.request = request;
        return this;
    }

    public ConfigBuilder person(Provider<Person> person) {
        this.person = person;
        return this;
    }

    public ConfigBuilder server(Provider<Server> server) {
        this.server = server;
        return this;
    }

    public ConfigBuilder client(Provider<Client> client) {
        this.client = client;
        return this;
    }

    public ConfigBuilder custom(Provider<Map<String, Object>> custom) {
        this.custom = custom;
        return this;
    }

    public ConfigBuilder notifier(Provider<Notifier> notifier) {
        this.notifier = notifier;
        return this;
    }

    public ConfigBuilder timestamp(Provider<Long> timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ConfigBuilder filter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public ConfigBuilder transformer(Transformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public ConfigBuilder fingerPrintGenerator(FingerprintGenerator fingerPrintGenerator) {
        this.fingerPrintGenerator = fingerPrintGenerator;
        return this;
    }

    public ConfigBuilder uuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
        return this;
    }

    public ConfigBuilder sender(Sender sender) {
        this.sender = sender;
        return this;
    }

    public ConfigBuilder jsonSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    public ConfigBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public ConfigBuilder appPackages(List<String> appPackages) {
        this.appPackages = appPackages;
        return this;
    }

    public ConfigBuilder handleUncaughtErrors(boolean handleUncaughtErrors) {
        this.handleUncaughtErrors = handleUncaughtErrors;
        return this;
    }

    public ConfigBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ConfigBuilder defaultMessageLevel(Level level) {
        this.defaultLevels.setMessage(level);
        return this;
    }

    public ConfigBuilder defaultErrorLevel(Level level) {
        this.defaultLevels.setError(level);
        return this;
    }

    public ConfigBuilder defaultThrowableLevel(Level level) {
        this.defaultLevels.setThrowable(level);
        return this;
    }

    public ConfigBuilder truncateLargePayloads(boolean truncate) {
        this.truncateLargePayloads = truncate;
        return this;
    }

    public Config build() {
        if (this.language == null) {
            this.language = "java";
        }
        if (this.endpoint == null) {
            this.endpoint = "https://api.rollbar.com/api/1/item/";
        }
        if (this.notifier == null) {
            this.notifier = new NotifierProvider();
        }
        if (this.sender == null) {
            SyncSender.Builder innerSender = new SyncSender.Builder(this.endpoint).accessToken(this.accessToken).proxy(this.proxy);
            if (this.jsonSerializer != null) {
                innerSender.jsonSerializer(this.jsonSerializer);
            }
            this.sender = new BufferedSender.Builder().sender(innerSender.build()).build();
        }
        if (this.timestamp == null) {
            this.timestamp = new TimestampProvider();
        }
        return new ConfigImpl(this);
    }

    private static class ConfigImpl
    implements Config {
        private final String accessToken;
        private final String endpoint;
        private final String environment;
        private final String codeVersion;
        private final String platform;
        private final String language;
        private final String framework;
        private final Provider<String> context;
        private final Provider<Request> request;
        private final Provider<Person> person;
        private final Provider<Server> server;
        private final Provider<Client> client;
        private final Provider<Map<String, Object>> custom;
        private final Provider<Notifier> notifier;
        private final Provider<Long> timestamp;
        private final Filter filter;
        private final Transformer transformer;
        private final FingerprintGenerator fingerPrintGenerator;
        private final UuidGenerator uuidGenerator;
        private final Sender sender;
        private final JsonSerializer jsonSerializer;
        private final Proxy proxy;
        private final List<String> appPackages;
        private final boolean handleUncaughtErrors;
        private final boolean enabled;
        private DefaultLevels defaultLevels;
        private final boolean truncateLargePayloads;

        ConfigImpl(ConfigBuilder builder) {
            this.accessToken = builder.accessToken;
            this.endpoint = builder.endpoint;
            this.environment = builder.environment;
            this.codeVersion = builder.codeVersion;
            this.platform = builder.platform;
            this.language = builder.language;
            this.framework = builder.framework;
            this.context = builder.context;
            this.request = builder.request;
            this.person = builder.person;
            this.server = builder.server;
            this.client = builder.client;
            this.custom = builder.custom;
            this.notifier = builder.notifier;
            this.timestamp = builder.timestamp;
            this.filter = builder.filter;
            this.transformer = builder.transformer;
            this.fingerPrintGenerator = builder.fingerPrintGenerator;
            this.uuidGenerator = builder.uuidGenerator;
            this.sender = builder.sender;
            this.jsonSerializer = builder.jsonSerializer;
            this.proxy = builder.proxy;
            this.appPackages = builder.appPackages == null ? Collections.emptyList() : builder.appPackages;
            this.handleUncaughtErrors = builder.handleUncaughtErrors;
            this.enabled = builder.enabled;
            this.defaultLevels = builder.defaultLevels;
            this.truncateLargePayloads = builder.truncateLargePayloads;
        }

        @Override
        public String accessToken() {
            return this.accessToken;
        }

        @Override
        public String endpoint() {
            return this.endpoint;
        }

        @Override
        public String environment() {
            return this.environment;
        }

        @Override
        public String codeVersion() {
            return this.codeVersion;
        }

        @Override
        public String platform() {
            return this.platform;
        }

        @Override
        public String language() {
            return this.language;
        }

        @Override
        public String framework() {
            return this.framework;
        }

        @Override
        public Provider<String> context() {
            return this.context;
        }

        @Override
        public Provider<Request> request() {
            return this.request;
        }

        @Override
        public Provider<Person> person() {
            return this.person;
        }

        @Override
        public Provider<Server> server() {
            return this.server;
        }

        @Override
        public Provider<Client> client() {
            return this.client;
        }

        @Override
        public Provider<Map<String, Object>> custom() {
            return this.custom;
        }

        @Override
        public Provider<Notifier> notifier() {
            return this.notifier;
        }

        @Override
        public Provider<Long> timestamp() {
            return this.timestamp;
        }

        @Override
        public Filter filter() {
            return this.filter;
        }

        @Override
        public Transformer transformer() {
            return this.transformer;
        }

        @Override
        public FingerprintGenerator fingerPrintGenerator() {
            return this.fingerPrintGenerator;
        }

        @Override
        public UuidGenerator uuidGenerator() {
            return this.uuidGenerator;
        }

        @Override
        public Sender sender() {
            return this.sender;
        }

        @Override
        public JsonSerializer jsonSerializer() {
            return this.jsonSerializer;
        }

        @Override
        public Proxy proxy() {
            return this.proxy;
        }

        @Override
        public List<String> appPackages() {
            return this.appPackages;
        }

        @Override
        public boolean handleUncaughtErrors() {
            return this.handleUncaughtErrors;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public Level defaultMessageLevel() {
            return this.defaultLevels.getMessage();
        }

        @Override
        public Level defaultErrorLevel() {
            return this.defaultLevels.getError();
        }

        @Override
        public Level defaultThrowableLevel() {
            return this.defaultLevels.getThrowable();
        }

        @Override
        public boolean truncateLargePayloads() {
            return this.truncateLargePayloads;
        }
    }
}

