/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.jvmti;

import com.rollbar.jvmti.CacheFrame;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class ThrowableCache {
    private static Set<String> appPackages = new HashSet<String>();
    private static ThreadLocal<WeakHashMap<Throwable, CacheFrame[]>> cache = new ThreadLocal<WeakHashMap<Throwable, CacheFrame[]>>(){

        @Override
        protected WeakHashMap<Throwable, CacheFrame[]> initialValue() {
            return new WeakHashMap<Throwable, CacheFrame[]>();
        }
    };

    private ThrowableCache() {
    }

    public static void add(Throwable throwable, CacheFrame[] frames) {
        Map weakMap = cache.get();
        weakMap.put(throwable, frames);
    }

    public static CacheFrame[] get(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Map weakMap = cache.get();
        return (CacheFrame[])weakMap.get(throwable);
    }

    public static boolean shouldCacheThrowable(Throwable throwable, int numFrames) {
        if (appPackages.isEmpty()) {
            return false;
        }
        Map weakMap = cache.get();
        CacheFrame[] existing = (CacheFrame[])weakMap.get(throwable);
        if (existing != null && numFrames <= existing.length) {
            return false;
        }
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            for (String appFrame : appPackages) {
                if (!stackTraceElement.getClassName().startsWith(appFrame)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addAppPackage(String newAppPackage) {
        appPackages.add(newAppPackage);
    }
}

