/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender.listener;

import com.rollbar.api.payload.Payload;
import com.rollbar.notifier.sender.listener.SenderListener;
import com.rollbar.notifier.sender.result.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SenderListenerCollection
implements SenderListener {
    private final List<SenderListener> listeners = new ArrayList<SenderListener>();

    @Override
    public void onResponse(Payload payload, Response response) {
        for (SenderListener listener : this.listeners) {
            listener.onResponse(payload, response);
        }
    }

    @Override
    public void onError(Payload payload, Exception error) {
        for (SenderListener listener : this.listeners) {
            listener.onError(payload, error);
        }
    }

    public List<SenderListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void addListener(SenderListener listener) {
        this.listeners.add(listener);
    }
}

