/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.filter;

import com.rollbar.api.payload.data.Data;
import com.rollbar.api.payload.data.Level;
import com.rollbar.notifier.filter.Filter;
import java.util.List;
import java.util.Map;

public class FilterPipeline
implements Filter {
    private final List<Filter> pipeline;

    public FilterPipeline() {
        this(null);
    }

    public FilterPipeline(List<Filter> pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public boolean preProcess(Level level, Throwable error, Map<String, Object> custom, String description) {
        if (this.usePipeline()) {
            return this.pipeline(level, error, custom, description);
        }
        return false;
    }

    @Override
    public boolean postProcess(Data data) {
        if (this.usePipeline()) {
            return this.pipeline(data);
        }
        return false;
    }

    private boolean usePipeline() {
        return this.pipeline != null && !this.pipeline.isEmpty();
    }

    private boolean pipeline(Level level, Throwable error, Map<String, Object> custom, String description) {
        for (Filter filter : this.pipeline) {
            boolean result = filter.preProcess(level, error, custom, description);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean pipeline(Data data) {
        for (Filter filter : this.pipeline) {
            boolean result = filter.postProcess(data);
            if (!result) continue;
            return true;
        }
        return false;
    }
}

