/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data.body;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.body.BodyContent;
import com.rollbar.api.payload.data.body.ExceptionInfo;
import com.rollbar.api.payload.data.body.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Trace
implements BodyContent,
JsonSerializable {
    private static final long serialVersionUID = 7477061203488507566L;
    private final List<Frame> frames;
    private final ExceptionInfo exception;

    private Trace(Builder builder) {
        this.frames = Collections.unmodifiableList(new ArrayList(builder.frames));
        this.exception = builder.exception;
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public ExceptionInfo getException() {
        return this.exception;
    }

    @Override
    public String getKeyName() {
        return "trace";
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.frames != null) {
            values.put("frames", this.frames);
        }
        if (this.exception != null) {
            values.put("exception", this.exception);
        }
        return values;
    }

    @Override
    public Trace truncateStrings(int maxLength) {
        if ((this.frames == null || this.frames.isEmpty()) && this.exception == null) {
            return this;
        }
        ArrayList<Frame> truncatedFrames = null;
        if (this.frames != null) {
            truncatedFrames = new ArrayList<Frame>();
            for (Frame f : this.frames) {
                truncatedFrames.add(f.truncateStrings(maxLength));
            }
        }
        ExceptionInfo truncatedException = null;
        if (this.exception != null) {
            truncatedException = this.exception.truncateStrings(maxLength);
        }
        return new Builder(this).frames(truncatedFrames).exception(truncatedException).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trace trace = (Trace)o;
        if (this.frames != null ? !this.frames.equals(trace.frames) : trace.frames != null) {
            return false;
        }
        return this.exception != null ? this.exception.equals(trace.exception) : trace.exception == null;
    }

    public int hashCode() {
        int result = this.frames != null ? this.frames.hashCode() : 0;
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Trace{frames=" + this.frames + ", exception=" + this.exception + '}';
    }

    public static final class Builder {
        private List<Frame> frames;
        private ExceptionInfo exception;

        public Builder() {
        }

        public Builder(Trace trace) {
            this.frames = trace.frames;
            this.exception = trace.exception;
        }

        public Builder frames(List<Frame> frames) {
            this.frames = frames;
            return this;
        }

        public Builder exception(ExceptionInfo exception) {
            this.exception = exception;
            return this;
        }

        public Trace build() {
            return new Trace(this);
        }
    }
}

