/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.utils;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.ActivityRecognition;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.places.Places;
import com.risesoftware.utils.logging.RSLog;
import java.util.Locale;

public class FragmentGmsClient
extends Fragment
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final String TAG_FRAG = FragmentGmsClient.class.getSimpleName();
    private static final int REQUEST_RESOLVE_ERROR = 1001;
    private static final String DIALOG_ERROR = "dialog_error";
    private GoogleApiClient m_googleApiClient = null;
    private boolean m_resolvingError = false;

    public static <A extends Activity> FragmentGmsClient attach(A parent) {
        return FragmentGmsClient.attach(parent.getFragmentManager());
    }

    private static FragmentGmsClient attach(FragmentManager fragmentManager) {
        FragmentGmsClient frag = (FragmentGmsClient)fragmentManager.findFragmentByTag(TAG_FRAG);
        if (null == frag) {
            frag = new FragmentGmsClient();
            fragmentManager.beginTransaction().add((Fragment)frag, TAG_FRAG).commit();
        }
        return frag;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (!this.isGooglePlayServicesAvailable()) {
            RSLog.e(TAG_FRAG, "Google Play services unavailable.");
            this.getActivity().finish();
            return;
        }
        this.m_googleApiClient = new GoogleApiClient.Builder((Context)this.getActivity()).addApi(ActivityRecognition.API).addApi(LocationServices.API).addApi(Places.GEO_DATA_API).addApi(Places.PLACE_DETECTION_API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
    }

    public void onStart() {
        super.onStart();
        if (!this.m_resolvingError) {
            this.m_googleApiClient.connect();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (1001 == requestCode) {
            this.m_resolvingError = false;
            if (-1 == resultCode && !this.m_googleApiClient.isConnecting() && !this.m_googleApiClient.isConnected()) {
                this.m_googleApiClient.connect();
            }
        }
    }

    public void onStop() {
        this.m_googleApiClient.disconnect();
        super.onStop();
    }

    private boolean isGooglePlayServicesAvailable() {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.getActivity());
        if (0 == resultCode) {
            RSLog.d(TAG_FRAG, "Google Play services is available.");
            return true;
        }
        RSLog.e(TAG_FRAG, "Google Play services is unavailable.");
        return false;
    }

    public void onConnected(Bundle bundle) {
        RSLog.v(TAG_FRAG, "onConnected");
        this.getParent().onConnected(this.m_googleApiClient, bundle);
    }

    public void onConnectionSuspended(int i) {
        RSLog.d(TAG_FRAG, "onConnectionSuspended");
        this.getParent().onConnectionSuspended(i);
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        RSLog.e(TAG_FRAG, String.format(Locale.getDefault(), "onConnectionFailed, connectionResult = %d ", connectionResult.getErrorCode()));
        this.getParent().onConnectionFailed(connectionResult);
        if (this.m_resolvingError) {
            return;
        }
        if (connectionResult.hasResolution()) {
            try {
                this.m_resolvingError = true;
                connectionResult.startResolutionForResult(this.getActivity(), 1001);
            }
            catch (IntentSender.SendIntentException e) {
                RSLog.e(TAG_FRAG, e.toString(), e);
                this.m_googleApiClient.connect();
            }
        } else {
            this.showErrorDialog(connectionResult.getErrorCode());
            this.m_resolvingError = true;
        }
    }

    private GmsClient getParent() {
        Activity activity = this.getActivity();
        if (activity instanceof GmsClient) {
            return (GmsClient)activity;
        }
        return null;
    }

    private void showErrorDialog(int errorCode) {
        ErrorDialogFragment dialogFragment = new ErrorDialogFragment();
        Bundle args = new Bundle();
        args.putInt(DIALOG_ERROR, errorCode);
        dialogFragment.setArguments(args);
        dialogFragment.show(this.getFragmentManager(), "errordialog");
    }

    public void onDialogDismissed() {
        this.m_resolvingError = false;
    }

    static {
        RSLog.LOG_LEVELS.put(TAG_FRAG, RSLog.ERROR);
    }

    public static class ErrorDialogFragment
    extends DialogFragment {
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            int errorCode = this.getArguments().getInt(FragmentGmsClient.DIALOG_ERROR);
            return GooglePlayServicesUtil.getErrorDialog((int)errorCode, (Activity)this.getActivity(), (int)1001);
        }
    }

    public static interface GmsClient {
        public void onConnected(GoogleApiClient var1, Bundle var2);

        public void onConnectionSuspended(int var1);

        public void onConnectionFailed(ConnectionResult var1);
    }
}

