/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.utils.logging;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public class RSLog {
    public static final int ASSERT = 7;
    public static final Integer ERROR = 6;
    public static final Integer WARN = 5;
    public static final Integer INFO = 4;
    public static final Integer DEBUG = 3;
    public static final Integer VERBOSE = 2;
    public static final Map<String, Integer> LOG_LEVELS = new HashMap<String, Integer>(5);

    public static int getLogLevel(String tag) {
        if (LOG_LEVELS.containsKey(tag)) {
            return LOG_LEVELS.get(tag);
        }
        return 2;
    }

    public static void e(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= ERROR) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= ERROR) {
            Log.e((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void w(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= WARN) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void w(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= WARN) {
            Log.w((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void i(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= INFO) {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void i(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= INFO) {
            Log.i((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void d(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= DEBUG) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void d(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= DEBUG) {
            Log.d((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void v(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= VERBOSE) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void v(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= VERBOSE) {
            Log.v((String)tag, (String)msg, (Throwable)throwable);
        }
    }
}

