/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.utils.logging;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public class RSLog {
    public static final int ASSERT = 7;
    public static final int ERROR = 6;
    public static final int WARN = 5;
    public static final int INFO = 4;
    public static final int DEBUG = 3;
    public static final int VERBOSE = 2;
    public static final Map<String, Integer> LOG_LEVELS = new HashMap<String, Integer>(5);

    public static int getLogLevel(String tag) {
        if (LOG_LEVELS.containsKey(tag)) {
            return LOG_LEVELS.get(tag);
        }
        return 2;
    }

    public static void e(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= 6) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void e(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= 6) {
            Log.e((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void w(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= 5) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static void w(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= 5) {
            Log.w((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void i(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= 4) {
            Log.i((String)tag, (String)msg);
        }
    }

    public static void i(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= 4) {
            Log.i((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void d(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= 3) {
            Log.d((String)tag, (String)msg);
        }
    }

    public static void d(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= 3) {
            Log.d((String)tag, (String)msg, (Throwable)throwable);
        }
    }

    public static void v(String tag, String msg) {
        if (RSLog.getLogLevel(tag) <= 2) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void v(String tag, String msg, Throwable throwable) {
        if (RSLog.getLogLevel(tag) <= 2) {
            Log.v((String)tag, (String)msg, (Throwable)throwable);
        }
    }
}

