/*
 * Decompiled with CFR 0.152.
 */
package com.risesoftware.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Log;
import com.risesoftware.utils.exceptions.Exception_RequiredParameter;
import com.risesoftware.utils.logging.RSLog;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public final class PackageUtils {
    public static final String TAG = PackageUtils.class.getSimpleName();
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA1";
    private static final String CERTIFICATE_FACTORY = "X509";
    private static final char SHA_SEPARATOR = ':';
    private static final char LEADING_ZERO = '0';

    private PackageUtils() {
    }

    public static String getAppVersionName(Context context) {
        if (null == context) {
            throw new Exception_RequiredParameter("context parameter must not be null");
        }
        try {
            String packageName = context.getPackageName();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            RSLog.e(context.toString(), e.getMessage(), e);
            return null;
        }
    }

    public static List<String> getPackageSignatureKeys(Context context, String packageName) {
        try {
            return PackageUtils.getPackageSignatureKeysOrThrow(context, packageName);
        }
        catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException | CertificateException e) {
            Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            return null;
        }
    }

    public static List<String> getPackageSignatureKeysOrThrow(Context context, String packageName) throws PackageManager.NameNotFoundException, CertificateException, NoSuchAlgorithmException {
        ArrayList<String> hashKeys = new ArrayList<String>(5);
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 64);
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CERTIFICATE_FACTORY);
        MessageDigest messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        if (null == packageInfo || null == certificateFactory || null == messageDigest) {
            return null;
        }
        for (Signature signature : packageInfo.signatures) {
            byte[] cert = signature.toByteArray();
            ByteArrayInputStream input = new ByteArrayInputStream(cert);
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(input);
            byte[] publicKey = messageDigest.digest(certificate.getEncoded());
            messageDigest.reset();
            hashKeys.add(PackageUtils.byte2HexFormattedSHA(publicKey));
        }
        return hashKeys;
    }

    public static String byte2HexFormattedSHA(byte[] arr) {
        StringBuilder stringBuilder = new StringBuilder(arr.length * 2);
        int arrLength = arr.length;
        for (int i = 0; i < arrLength; ++i) {
            String hexString = Integer.toHexString(arr[i]);
            int length = hexString.length();
            if (1 == length) {
                hexString = '0' + hexString;
            }
            if (2 < length) {
                hexString = hexString.substring(length - 2, length);
            }
            stringBuilder.append(hexString.toUpperCase());
            if (i >= arr.length - 1) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    static {
        RSLog.LOG_LEVELS.put(TAG, 5);
    }
}

