/*
 * Decompiled with CFR 0.152.
 */
package com.riningan.widget;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.riningan.widget.R;

public class CircularProgressBar
extends View {
    private static final int START_ANGLE = 270;
    private static final int STOP_ANGLE = 360;
    private StateEnum mState = StateEnum.Loading;
    private float mProgressValue = 0.0f;
    private float mProgressWidth;
    private int mProgressColor;
    private float mBackgroundWidth;
    private int mBackgroundColor;
    private RectF mRectF;
    private Paint mBackgroundPaint;
    private Paint mProgressPaint;
    private ObjectAnimator mLoadingAnimator;

    public CircularProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircularProgressBar, 0, 0);
        int state = typedArray.getInt(R.styleable.CircularProgressBar_cpb_state, 1);
        if (state == 1) {
            this.mState = StateEnum.Loading;
            this.mProgressValue = 0.0f;
        } else {
            this.mState = state == 2 ? StateEnum.ProgressDirect : StateEnum.ProgressInvert;
            this.mProgressValue = typedArray.getFloat(R.styleable.CircularProgressBar_cpb_progress_value, this.mProgressValue);
        }
        this.mProgressWidth = typedArray.getDimension(R.styleable.CircularProgressBar_cpb_progress_width, this.getResources().getDimension(R.dimen.default_cpb_progress_width));
        this.mBackgroundWidth = typedArray.getDimension(R.styleable.CircularProgressBar_cpb_background_width, this.getResources().getDimension(R.dimen.default_cpb_background_width));
        this.mProgressColor = typedArray.getInt(R.styleable.CircularProgressBar_cpb_progress_color, -16777216);
        this.mBackgroundColor = typedArray.getInt(R.styleable.CircularProgressBar_cpb_background_color, -7829368);
        typedArray.recycle();
        this.mRectF = new RectF();
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundPaint.setStrokeWidth(this.mBackgroundWidth);
        this.mProgressPaint = new Paint(1);
        this.mProgressPaint.setColor(this.mProgressColor);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint.setStrokeWidth(this.mProgressWidth);
        if (this.mState == StateEnum.Loading) {
            this.mLoadingAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{100.0f});
            this.mLoadingAnimator.setDuration(2000L);
            this.mLoadingAnimator.setRepeatCount(-1);
            this.mLoadingAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mLoadingAnimator.start();
        } else {
            this.mLoadingAnimator = null;
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawOval(this.mRectF, this.mBackgroundPaint);
        if (this.mState == StateEnum.Loading) {
            if (this.mProgressValue <= 50.0f) {
                float angle = 360.0f * this.mProgressValue / 50.0f;
                canvas.drawArc(this.mRectF, 270.0f, angle, false, this.mProgressPaint);
            } else {
                float angle = 360.0f * (this.mProgressValue - 50.0f) / 50.0f;
                canvas.drawArc(this.mRectF, 270.0f + angle, 360.0f - angle, false, this.mProgressPaint);
            }
        } else if (this.mState == StateEnum.ProgressDirect) {
            float angle = 360.0f * this.mProgressValue / 100.0f;
            canvas.drawArc(this.mRectF, 270.0f, angle, false, this.mProgressPaint);
        } else {
            float angle = 360.0f * this.mProgressValue / 100.0f - 360.0f;
            canvas.drawArc(this.mRectF, 270.0f, angle, false, this.mProgressPaint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = CircularProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = CircularProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        this.setMeasuredDimension(min, min);
        float highStroke = this.mProgressWidth > this.mBackgroundWidth ? this.mProgressWidth : this.mBackgroundWidth;
        this.mRectF.set(0.0f + highStroke / 2.0f, 0.0f + highStroke / 2.0f, (float)min - highStroke / 2.0f, (float)min - highStroke / 2.0f);
    }

    public StateEnum getState() {
        return this.mState;
    }

    public void setState(StateEnum state) {
        this.mState = state;
        this.stopLoadingAnimation();
        if (this.mState == StateEnum.Loading) {
            this.mProgressValue = 0.0f;
            this.mLoadingAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{100.0f});
            this.mLoadingAnimator.setDuration(2000L);
            this.mLoadingAnimator.setRepeatCount(-1);
            this.mLoadingAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mLoadingAnimator.start();
        }
        this.requestLayout();
        this.invalidate();
    }

    public float getProgressWidth() {
        return this.mProgressWidth;
    }

    public void setProgressWidth(float progressWidth) {
        this.mProgressWidth = progressWidth;
        this.mProgressPaint.setStrokeWidth(progressWidth);
        this.requestLayout();
        this.invalidate();
    }

    public float getBackgroundWidth() {
        return this.mBackgroundWidth;
    }

    public void setBackgroundWidth(float backgroundWidth) {
        this.mBackgroundWidth = backgroundWidth;
        this.mBackgroundPaint.setStrokeWidth(backgroundWidth);
        this.requestLayout();
        this.invalidate();
    }

    @ColorInt
    public int getProgressColor() {
        return this.mProgressColor;
    }

    public void setProgressColor(@ColorInt int progressColor) {
        this.mProgressColor = progressColor;
        this.mProgressPaint.setColor(progressColor);
        this.invalidate();
        this.requestLayout();
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        this.mBackgroundPaint.setColor(backgroundColor);
        this.invalidate();
        this.requestLayout();
    }

    public float getProgress() {
        return this.mProgressValue;
    }

    public void setProgress(float progress) {
        this.mProgressValue = progress <= 100.0f ? progress : 100.0f;
        this.invalidate();
    }

    public void setProgressWithAnimation(float progress) {
        this.setProgressWithAnimation(progress, StateEnum.ProgressDirect);
    }

    public void setProgressWithAnimation(float progress, StateEnum state) {
        this.setProgressWithAnimation(progress, 1500);
    }

    public void setProgressWithAnimation(float progress, int duration) {
        this.setProgressWithAnimation(progress, 1500, StateEnum.ProgressDirect);
    }

    public void setProgressWithAnimation(float progress, int duration, StateEnum state) {
        if (this.mState != state) {
            this.setState(StateEnum.ProgressDirect);
        }
        if (this.mState == StateEnum.Loading) {
            return;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{progress});
        objectAnimator.setDuration((long)duration);
        objectAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        objectAnimator.start();
    }

    public void stopLoadingAnimation() {
        if (this.mLoadingAnimator != null) {
            this.mLoadingAnimator.end();
            this.mLoadingAnimator = null;
        }
    }

    public static enum StateEnum {
        Loading,
        ProgressDirect,
        ProgressInvert;

    }
}

