/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.JsonLoader;
import com.reprezen.jsonoverlay.ReferenceManager;
import com.reprezen.kaizen.oasparser.OpenApi;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.ovl3.OpenApi3Impl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class OpenApiParser {
    public OpenApi<?> parse(String spec, URL resolutionBase) {
        return this.parse(spec, resolutionBase, true);
    }

    public OpenApi<?> parse(String spec, URL resolutionBase, boolean validate) {
        try {
            JsonLoader loader = new JsonLoader();
            JsonNode tree = loader.loadString(resolutionBase, spec);
            return this.parse(tree, resolutionBase, validate, loader);
        }
        catch (IOException e) {
            throw new OpenApiParserException("Failed to parse spec as JSON or YAML", e);
        }
    }

    public OpenApi<?> parse(File specFile) throws Exception {
        return this.parse(specFile, true);
    }

    public OpenApi<?> parse(File specFile, boolean validate) throws Exception {
        try {
            return this.parse(specFile.toURI().toURL(), validate);
        }
        catch (IOException e) {
            throw new OpenApiParserException("Failed to read spec from file", e);
        }
    }

    public OpenApi<?> parse(URI uri) throws Exception {
        return this.parse(uri, true);
    }

    public OpenApi<?> parse(URI uri, boolean validate) throws Exception {
        try {
            return this.parse(uri.toURL(), validate);
        }
        catch (MalformedURLException e) {
            throw new OpenApiParserException("Invalid URI for Swagger spec", e);
        }
    }

    public OpenApi<?> parse(URL resolutionBase) throws Exception {
        return this.parse(resolutionBase, true);
    }

    public OpenApi<?> parse(URL resolutionBase, boolean validate) throws Exception {
        ReferenceManager manager = new ReferenceManager(resolutionBase);
        return this.parse(manager, validate);
    }

    public OpenApi<?> parse(JsonNode tree, URL resolutionBase) {
        return this.parse(tree, resolutionBase, true);
    }

    public OpenApi<?> parse(JsonNode tree, URL resolutionBase, boolean validate) {
        return this.parse(tree, resolutionBase, validate, null);
    }

    public OpenApi<?> parse(JsonNode tree, URL resolutionBase, boolean validate, JsonLoader loader) {
        ReferenceManager manager = new ReferenceManager(resolutionBase, tree, loader);
        return this.parse(manager, validate);
    }

    private OpenApi<?> parse(ReferenceManager manager, boolean validate) {
        try {
            JsonNode tree = manager.loadDoc();
            if (this.isVersion3(tree)) {
                OpenApi3 model = (OpenApi3)OpenApi3Impl.factory.create(tree, null, manager);
                ((OpenApi3Impl)model)._setCreatingRef(manager.getDocReference());
                if (validate) {
                    model.validate();
                }
                return model;
            }
            throw new OpenApiParserException("Could not determine OpenApi version from model: no 'openapi' property");
        }
        catch (IOException e) {
            throw new OpenApiParserException("Failed to parse model", e);
        }
    }

    protected boolean isVersion3(JsonNode tree) {
        JsonNode versionNode = tree.path("openapi");
        return versionNode.isTextual() && versionNode.asText().startsWith("3.");
    }

    public static class OpenApiParserException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public OpenApiParserException() {
        }

        public OpenApiParserException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public OpenApiParserException(String message, Throwable cause) {
            super(message, cause);
        }

        public OpenApiParserException(String message) {
            super(message);
        }

        public OpenApiParserException(Throwable cause) {
            super(cause);
        }
    }
}

