/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.processor.collector;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.Processor;
import java.util.Collection;
import java.util.List;
import org.finos.rune.mapper.processor.collector.CollectorStrategy;

public class PreSerializationCollector
implements Processor {
    private final List<CollectorStrategy> collectorStrategies;

    public PreSerializationCollector(CollectorStrategy ... collectorStrategies) {
        this.collectorStrategies = Lists.newArrayList((Object[])collectorStrategies);
    }

    public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, R instance, RosettaModelObject parent, AttributeMeta ... metas) {
        for (CollectorStrategy collectorStrategy : this.collectorStrategies) {
            collectorStrategy.collect(instance);
        }
        return true;
    }

    public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, List<? extends R> instances, RosettaModelObject parent, AttributeMeta ... metas) {
        if (instances == null) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < instances.size(); ++i) {
            RosettaModelObject instance = (RosettaModelObject)instances.get(i);
            path = path.withIndex(i);
            result &= this.processRosetta(path, rosettaType, instance, parent, metas);
        }
        return result;
    }

    public <T> void processBasic(RosettaPath path, Class<? extends T> rosettaType, T instance, RosettaModelObject parent, AttributeMeta ... metas) {
    }

    public <T> void processBasic(RosettaPath path, Class<? extends T> rosettaType, Collection<? extends T> instances, RosettaModelObject parent, AttributeMeta ... metas) {
        if (instances == null) {
            return;
        }
        for (T instance : instances) {
            this.processBasic(path, rosettaType, instance, parent, metas);
        }
    }

    public Processor.Report report() {
        throw new UnsupportedOperationException("Report not supported for UnreferencedKeyCollector");
    }
}

