/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.processor;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Set;
import org.finos.rune.mapper.processor.GlobalReferenceRecord;
import org.finos.rune.mapper.processor.collector.GlobalReferenceCollectorStrategy;
import org.finos.rune.mapper.processor.collector.KeyCollectorStrategy;
import org.finos.rune.mapper.processor.collector.KeyLookupService;
import org.finos.rune.mapper.processor.collector.PreSerializationCollector;
import org.finos.rune.mapper.processor.pruner.GlobalKeyPruningStrategy;
import org.finos.rune.mapper.processor.pruner.PreSerializationPruner;
import org.finos.rune.mapper.processor.pruner.ReferencePruningStrategy;

public class SerializationPreProcessor {
    public <T extends RosettaModelObject> T process(T rosettaModelObject) {
        RosettaPath path = RosettaPath.valueOf((String)rosettaModelObject.getType().getSimpleName());
        RosettaModelObjectBuilder builder = rosettaModelObject.toBuilder();
        KeyLookupService keyLookupService = this.getKeyInformationForAllKeyTypes(builder, path);
        this.pruneDuplicateReferences(keyLookupService, builder, path);
        Set<GlobalReferenceRecord> globalReferences = this.getAllGlobalReferences(builder, path);
        this.pruneGlobalKeysAndEmptyAttributes(globalReferences, builder, path);
        return this.buildAndCast(builder);
    }

    private void pruneGlobalKeysAndEmptyAttributes(Set<GlobalReferenceRecord> globalReferences, RosettaModelObjectBuilder builder, RosettaPath path) {
        GlobalKeyPruningStrategy globalKeyPruningStrategy = new GlobalKeyPruningStrategy(globalReferences);
        PreSerializationPruner keyAndAttributePruning = new PreSerializationPruner(globalKeyPruningStrategy);
        builder.process(path, (BuilderProcessor)keyAndAttributePruning);
        builder.prune();
    }

    private Set<GlobalReferenceRecord> getAllGlobalReferences(RosettaModelObjectBuilder builder, RosettaPath path) {
        GlobalReferenceCollectorStrategy globalReferenceCollectorStrategy = new GlobalReferenceCollectorStrategy();
        PreSerializationCollector globalReferenceCollector = new PreSerializationCollector(globalReferenceCollectorStrategy);
        builder.process(path, (Processor)globalReferenceCollector);
        return globalReferenceCollectorStrategy.getGlobalReferences();
    }

    private void pruneDuplicateReferences(KeyLookupService keyLookupService, RosettaModelObjectBuilder builder, RosettaPath path) {
        ReferencePruningStrategy referencePruningStrategy = new ReferencePruningStrategy(keyLookupService);
        PreSerializationPruner referencePruning = new PreSerializationPruner(referencePruningStrategy);
        builder.process(path, (BuilderProcessor)referencePruning);
    }

    private KeyLookupService getKeyInformationForAllKeyTypes(RosettaModelObjectBuilder builder, RosettaPath path) {
        KeyCollectorStrategy keyCollectorStrategy = new KeyCollectorStrategy();
        PreSerializationCollector keyLookupCollector = new PreSerializationCollector(keyCollectorStrategy);
        builder.process(path, (Processor)keyLookupCollector);
        return keyCollectorStrategy.getKeyLookupService();
    }

    private <T extends RosettaModelObject> T buildAndCast(RosettaModelObjectBuilder builder) {
        return (T)builder.build();
    }
}

