/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.introspector;

import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import java.util.function.BiFunction;

public class RuneEnumBuilderIntrospector {
    public static final Class<RosettaEnum> ENUM_ANNOTATION = RosettaEnum.class;
    public static final Class<RosettaEnumValue> ENUM_VALUE_ANNOTATION = RosettaEnumValue.class;
    private final EnumNameFunc enumNameFunc = (annotation, javaEnumName) -> !annotation.displayName().isEmpty() ? annotation.displayName() : annotation.value();
    private final EnumAliasFunc enumAliasFunc = (annotation, javaEnumName) -> {
        String[] stringArray;
        if (!annotation.displayName().isEmpty()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = javaEnumName;
            stringArray2[1] = annotation.displayName();
            stringArray = stringArray2;
            stringArray2[2] = annotation.value();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = javaEnumName;
            stringArray = stringArray3;
            stringArray3[1] = annotation.value();
        }
        return stringArray;
    };

    public boolean isApplicable(AnnotatedClass enumType) {
        return enumType.getAnnotation(ENUM_ANNOTATION) != null;
    }

    public void findEnumValues(AnnotatedClass enumType, Enum<?>[] enumValues, String[] names) {
        this.processEnumAnnotations(enumType, enumValues, this.enumNameFunc, names);
    }

    public void findEnumAliases(AnnotatedClass enumType, Enum<?>[] enumValues, String[][] aliasList) {
        this.processEnumAnnotations(enumType, enumValues, this.enumAliasFunc, (T[])aliasList);
    }

    private <T> void processEnumAnnotations(AnnotatedClass enumType, Enum<?>[] enumValues, BiFunction<RosettaEnumValue, String, T> mapper, T[] results) {
        block0: for (AnnotatedField f : enumType.fields()) {
            if (!f.hasAnnotation(ENUM_VALUE_ANNOTATION)) continue;
            RosettaEnumValue annotation = (RosettaEnumValue)f.getAnnotation(ENUM_VALUE_ANNOTATION);
            String name = f.getName();
            int end = enumValues.length;
            for (int i = 0; i < end; ++i) {
                if (!name.equals(enumValues[i].name())) continue;
                results[i] = mapper.apply(annotation, name);
                continue block0;
            }
        }
    }

    private static interface EnumNameFunc
    extends BiFunction<RosettaEnumValue, String, String> {
    }

    private static interface EnumAliasFunc
    extends BiFunction<RosettaEnumValue, String, String[]> {
    }
}

