/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation.fpmlreporting;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.PartyPortfolioName;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.doc.QueryParameter;
import fpml.consolidated.shared.TradeId;
import fpml.consolidated.valuation.fpmlreporting.Portfolio;
import fpml.consolidated.valuation.fpmlreporting.meta.QueryPortfolioMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="QueryPortfolio", builder=QueryPortfolioBuilderImpl.class, version="1.2.2")
@RuneDataType(value="QueryPortfolio", model="fpml", builder=QueryPortfolioBuilderImpl.class, version="1.2.2")
public interface QueryPortfolio
extends Portfolio {
    public static final QueryPortfolioMeta metaData = new QueryPortfolioMeta();

    public List<? extends QueryParameter> getQueryParameter();

    @Override
    public QueryPortfolio build();

    @Override
    public QueryPortfolioBuilder toBuilder();

    public static QueryPortfolioBuilder builder() {
        return new QueryPortfolioBuilderImpl();
    }

    default public RosettaMetaData<? extends QueryPortfolio> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends QueryPortfolio> getType() {
        return QueryPortfolio.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyPortfolioName"), processor, PartyPortfolioName.class, this.getPartyPortfolioName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeId"), processor, TradeId.class, this.getTradeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.class, this.getPortfolio(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("queryParameter"), processor, QueryParameter.class, this.getQueryParameter(), new AttributeMeta[0]);
    }

    public static class QueryPortfolioBuilderImpl
    extends Portfolio.PortfolioBuilderImpl
    implements QueryPortfolioBuilder {
        protected List<QueryParameter.QueryParameterBuilder> queryParameter = new ArrayList<QueryParameter.QueryParameterBuilder>();

        @Override
        @RosettaAttribute(value="queryParameter")
        @RuneAttribute(value="queryParameter")
        public List<? extends QueryParameter.QueryParameterBuilder> getQueryParameter() {
            return this.queryParameter;
        }

        @Override
        public QueryParameter.QueryParameterBuilder getOrCreateQueryParameter(int index) {
            if (this.queryParameter == null) {
                this.queryParameter = new ArrayList<QueryParameter.QueryParameterBuilder>();
            }
            return (QueryParameter.QueryParameterBuilder)this.getIndex(this.queryParameter, index, () -> {
                QueryParameter.QueryParameterBuilder newQueryParameter = QueryParameter.builder();
                return newQueryParameter;
            });
        }

        @Override
        @RosettaAttribute(value="partyPortfolioName")
        @RuneAttribute(value="partyPortfolioName")
        public QueryPortfolioBuilder setPartyPortfolioName(PartyPortfolioName _partyPortfolioName) {
            this.partyPortfolioName = _partyPortfolioName == null ? null : _partyPortfolioName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeId")
        @RuneAttribute(value="tradeId")
        public QueryPortfolioBuilder addTradeId(TradeId _tradeId) {
            if (_tradeId != null) {
                this.tradeId.add(_tradeId.toBuilder());
            }
            return this;
        }

        @Override
        public QueryPortfolioBuilder addTradeId(TradeId _tradeId, int idx) {
            this.getIndex(this.tradeId, idx, () -> _tradeId.toBuilder());
            return this;
        }

        @Override
        public QueryPortfolioBuilder addTradeId(List<? extends TradeId> tradeIds) {
            if (tradeIds != null) {
                for (TradeId tradeId : tradeIds) {
                    this.tradeId.add(tradeId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeId")
        public QueryPortfolioBuilder setTradeId(List<? extends TradeId> tradeIds) {
            this.tradeId = tradeIds == null ? new ArrayList() : (List)tradeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public QueryPortfolioBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier) {
            if (_partyTradeIdentifier != null) {
                this.partyTradeIdentifier.add(_partyTradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public QueryPortfolioBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier, int idx) {
            this.getIndex(this.partyTradeIdentifier, idx, () -> _partyTradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public QueryPortfolioBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            if (partyTradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : partyTradeIdentifiers) {
                    this.partyTradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyTradeIdentifier")
        public QueryPortfolioBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            this.partyTradeIdentifier = partyTradeIdentifiers == null ? new ArrayList() : (List)partyTradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public QueryPortfolioBuilder addPortfolio(Portfolio _portfolio) {
            if (_portfolio != null) {
                this.portfolio.add(_portfolio.toBuilder());
            }
            return this;
        }

        @Override
        public QueryPortfolioBuilder addPortfolio(Portfolio _portfolio, int idx) {
            this.getIndex(this.portfolio, idx, () -> _portfolio.toBuilder());
            return this;
        }

        @Override
        public QueryPortfolioBuilder addPortfolio(List<? extends Portfolio> portfolios) {
            if (portfolios != null) {
                for (Portfolio portfolio : portfolios) {
                    this.portfolio.add(portfolio.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolio")
        public QueryPortfolioBuilder setPortfolio(List<? extends Portfolio> portfolios) {
            this.portfolio = portfolios == null ? new ArrayList() : (List)portfolios.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public QueryPortfolioBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="queryParameter")
        @RuneAttribute(value="queryParameter")
        public QueryPortfolioBuilder addQueryParameter(QueryParameter _queryParameter) {
            if (_queryParameter != null) {
                this.queryParameter.add(_queryParameter.toBuilder());
            }
            return this;
        }

        @Override
        public QueryPortfolioBuilder addQueryParameter(QueryParameter _queryParameter, int idx) {
            this.getIndex(this.queryParameter, idx, () -> _queryParameter.toBuilder());
            return this;
        }

        @Override
        public QueryPortfolioBuilder addQueryParameter(List<? extends QueryParameter> queryParameters) {
            if (queryParameters != null) {
                for (QueryParameter queryParameter : queryParameters) {
                    this.queryParameter.add(queryParameter.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="queryParameter")
        public QueryPortfolioBuilder setQueryParameter(List<? extends QueryParameter> queryParameters) {
            this.queryParameter = queryParameters == null ? new ArrayList<QueryParameter.QueryParameterBuilder>() : (List)queryParameters.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public QueryPortfolio build() {
            return new QueryPortfolioImpl(this);
        }

        @Override
        public QueryPortfolioBuilder toBuilder() {
            return this;
        }

        @Override
        public QueryPortfolioBuilder prune() {
            super.prune();
            this.queryParameter = this.queryParameter.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getQueryParameter() != null && this.getQueryParameter().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public QueryPortfolioBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            QueryPortfolioBuilder o = (QueryPortfolioBuilder)other;
            merger.mergeRosetta(this.getQueryParameter(), o.getQueryParameter(), this::getOrCreateQueryParameter);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            QueryPortfolio _that = (QueryPortfolio)this.getType().cast(o);
            return ListEquals.listEquals(this.queryParameter, _that.getQueryParameter());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.queryParameter != null ? this.queryParameter.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "QueryPortfolioBuilder {queryParameter=" + String.valueOf(this.queryParameter) + "} " + super.toString();
        }
    }

    public static interface QueryPortfolioBuilder
    extends QueryPortfolio,
    Portfolio.PortfolioBuilder {
        public QueryParameter.QueryParameterBuilder getOrCreateQueryParameter(int var1);

        public List<? extends QueryParameter.QueryParameterBuilder> getQueryParameter();

        @Override
        public QueryPortfolioBuilder setPartyPortfolioName(PartyPortfolioName var1);

        @Override
        public QueryPortfolioBuilder addTradeId(TradeId var1);

        @Override
        public QueryPortfolioBuilder addTradeId(TradeId var1, int var2);

        @Override
        public QueryPortfolioBuilder addTradeId(List<? extends TradeId> var1);

        @Override
        public QueryPortfolioBuilder setTradeId(List<? extends TradeId> var1);

        @Override
        public QueryPortfolioBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1);

        @Override
        public QueryPortfolioBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1, int var2);

        @Override
        public QueryPortfolioBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        @Override
        public QueryPortfolioBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        @Override
        public QueryPortfolioBuilder addPortfolio(Portfolio var1);

        @Override
        public QueryPortfolioBuilder addPortfolio(Portfolio var1, int var2);

        @Override
        public QueryPortfolioBuilder addPortfolio(List<? extends Portfolio> var1);

        @Override
        public QueryPortfolioBuilder setPortfolio(List<? extends Portfolio> var1);

        @Override
        public QueryPortfolioBuilder setId(String var1);

        public QueryPortfolioBuilder addQueryParameter(QueryParameter var1);

        public QueryPortfolioBuilder addQueryParameter(QueryParameter var1, int var2);

        public QueryPortfolioBuilder addQueryParameter(List<? extends QueryParameter> var1);

        public QueryPortfolioBuilder setQueryParameter(List<? extends QueryParameter> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyPortfolioName"), processor, PartyPortfolioName.PartyPortfolioNameBuilder.class, (RosettaModelObjectBuilder)this.getPartyPortfolioName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeId"), processor, TradeId.TradeIdBuilder.class, this.getTradeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.PortfolioBuilder.class, this.getPortfolio(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("queryParameter"), processor, QueryParameter.QueryParameterBuilder.class, this.getQueryParameter(), new AttributeMeta[0]);
        }

        @Override
        public QueryPortfolioBuilder prune();
    }

    public static class QueryPortfolioImpl
    extends Portfolio.PortfolioImpl
    implements QueryPortfolio {
        private final List<? extends QueryParameter> queryParameter;

        protected QueryPortfolioImpl(QueryPortfolioBuilder builder) {
            super(builder);
            this.queryParameter = Optional.ofNullable(builder.getQueryParameter()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="queryParameter")
        @RuneAttribute(value="queryParameter")
        public List<? extends QueryParameter> getQueryParameter() {
            return this.queryParameter;
        }

        @Override
        public QueryPortfolio build() {
            return this;
        }

        @Override
        public QueryPortfolioBuilder toBuilder() {
            QueryPortfolioBuilder builder = QueryPortfolio.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QueryPortfolioBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getQueryParameter()).ifPresent(builder::setQueryParameter);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            QueryPortfolio _that = (QueryPortfolio)this.getType().cast(o);
            return ListEquals.listEquals(this.queryParameter, _that.getQueryParameter());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.queryParameter != null ? this.queryParameter.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "QueryPortfolio {queryParameter=" + String.valueOf(this.queryParameter) + "} " + super.toString();
        }
    }
}

