/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation.fpmlreporting;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.PartyPortfolioName;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.shared.TradeId;
import fpml.consolidated.valuation.fpmlreporting.meta.PortfolioMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Portfolio", builder=PortfolioBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Portfolio", model="fpml", builder=PortfolioBuilderImpl.class, version="1.2.2")
public interface Portfolio
extends RosettaModelObject {
    public static final PortfolioMeta metaData = new PortfolioMeta();

    public PartyPortfolioName getPartyPortfolioName();

    public List<? extends TradeId> getTradeId();

    public List<? extends PartyTradeIdentifier> getPartyTradeIdentifier();

    public List<? extends Portfolio> getPortfolio();

    public String getId();

    public Portfolio build();

    public PortfolioBuilder toBuilder();

    public static PortfolioBuilder builder() {
        return new PortfolioBuilderImpl();
    }

    default public RosettaMetaData<? extends Portfolio> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Portfolio> getType() {
        return Portfolio.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyPortfolioName"), processor, PartyPortfolioName.class, this.getPartyPortfolioName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeId"), processor, TradeId.class, this.getTradeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolio"), processor, Portfolio.class, this.getPortfolio(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PortfolioBuilderImpl
    implements PortfolioBuilder {
        protected PartyPortfolioName.PartyPortfolioNameBuilder partyPortfolioName;
        protected List<TradeId.TradeIdBuilder> tradeId = new ArrayList<TradeId.TradeIdBuilder>();
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> partyTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected List<PortfolioBuilder> portfolio = new ArrayList<PortfolioBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="partyPortfolioName")
        @RuneAttribute(value="partyPortfolioName")
        public PartyPortfolioName.PartyPortfolioNameBuilder getPartyPortfolioName() {
            return this.partyPortfolioName;
        }

        @Override
        public PartyPortfolioName.PartyPortfolioNameBuilder getOrCreatePartyPortfolioName() {
            PartyPortfolioName.PartyPortfolioNameBuilder result = this.partyPortfolioName != null ? this.partyPortfolioName : (this.partyPortfolioName = PartyPortfolioName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeId")
        @RuneAttribute(value="tradeId")
        public List<? extends TradeId.TradeIdBuilder> getTradeId() {
            return this.tradeId;
        }

        @Override
        public TradeId.TradeIdBuilder getOrCreateTradeId(int index) {
            if (this.tradeId == null) {
                this.tradeId = new ArrayList<TradeId.TradeIdBuilder>();
            }
            return (TradeId.TradeIdBuilder)this.getIndex(this.tradeId, index, () -> {
                TradeId.TradeIdBuilder newTradeId = TradeId.builder();
                return newTradeId;
            });
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier(int index) {
            if (this.partyTradeIdentifier == null) {
                this.partyTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.partyTradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newPartyTradeIdentifier = PartyTradeIdentifier.builder();
                return newPartyTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public List<? extends PortfolioBuilder> getPortfolio() {
            return this.portfolio;
        }

        @Override
        public PortfolioBuilder getOrCreatePortfolio(int index) {
            if (this.portfolio == null) {
                this.portfolio = new ArrayList<PortfolioBuilder>();
            }
            return (PortfolioBuilder)this.getIndex(this.portfolio, index, () -> {
                PortfolioBuilder newPortfolio = Portfolio.builder();
                return newPortfolio;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="partyPortfolioName")
        @RuneAttribute(value="partyPortfolioName")
        public PortfolioBuilder setPartyPortfolioName(PartyPortfolioName _partyPortfolioName) {
            this.partyPortfolioName = _partyPortfolioName == null ? null : _partyPortfolioName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeId")
        @RuneAttribute(value="tradeId")
        public PortfolioBuilder addTradeId(TradeId _tradeId) {
            if (_tradeId != null) {
                this.tradeId.add(_tradeId.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioBuilder addTradeId(TradeId _tradeId, int idx) {
            this.getIndex(this.tradeId, idx, () -> _tradeId.toBuilder());
            return this;
        }

        @Override
        public PortfolioBuilder addTradeId(List<? extends TradeId> tradeIds) {
            if (tradeIds != null) {
                for (TradeId tradeId : tradeIds) {
                    this.tradeId.add(tradeId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeId")
        public PortfolioBuilder setTradeId(List<? extends TradeId> tradeIds) {
            this.tradeId = tradeIds == null ? new ArrayList<TradeId.TradeIdBuilder>() : (List)tradeIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public PortfolioBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier) {
            if (_partyTradeIdentifier != null) {
                this.partyTradeIdentifier.add(_partyTradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier, int idx) {
            this.getIndex(this.partyTradeIdentifier, idx, () -> _partyTradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public PortfolioBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            if (partyTradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : partyTradeIdentifiers) {
                    this.partyTradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyTradeIdentifier")
        public PortfolioBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            this.partyTradeIdentifier = partyTradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)partyTradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public PortfolioBuilder addPortfolio(Portfolio _portfolio) {
            if (_portfolio != null) {
                this.portfolio.add(_portfolio.toBuilder());
            }
            return this;
        }

        @Override
        public PortfolioBuilder addPortfolio(Portfolio _portfolio, int idx) {
            this.getIndex(this.portfolio, idx, () -> _portfolio.toBuilder());
            return this;
        }

        @Override
        public PortfolioBuilder addPortfolio(List<? extends Portfolio> portfolios) {
            if (portfolios != null) {
                for (Portfolio portfolio : portfolios) {
                    this.portfolio.add(portfolio.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolio")
        public PortfolioBuilder setPortfolio(List<? extends Portfolio> portfolios) {
            this.portfolio = portfolios == null ? new ArrayList<PortfolioBuilder>() : (List)portfolios.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PortfolioBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public Portfolio build() {
            return new PortfolioImpl(this);
        }

        @Override
        public PortfolioBuilder toBuilder() {
            return this;
        }

        @Override
        public PortfolioBuilder prune() {
            if (this.partyPortfolioName != null && !this.partyPortfolioName.prune().hasData()) {
                this.partyPortfolioName = null;
            }
            this.tradeId = this.tradeId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyTradeIdentifier = this.partyTradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.portfolio = this.portfolio.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyPortfolioName() != null && this.getPartyPortfolioName().hasData()) {
                return true;
            }
            if (this.getTradeId() != null && this.getTradeId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyTradeIdentifier() != null && this.getPartyTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPortfolio() != null && this.getPortfolio().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public PortfolioBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PortfolioBuilder o = (PortfolioBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyPortfolioName(), (RosettaModelObjectBuilder)o.getPartyPortfolioName(), this::setPartyPortfolioName);
            merger.mergeRosetta(this.getTradeId(), o.getTradeId(), this::getOrCreateTradeId);
            merger.mergeRosetta(this.getPartyTradeIdentifier(), o.getPartyTradeIdentifier(), this::getOrCreatePartyTradeIdentifier);
            merger.mergeRosetta(this.getPortfolio(), o.getPortfolio(), this::getOrCreatePortfolio);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Portfolio _that = this.getType().cast(o);
            if (!Objects.equals(this.partyPortfolioName, _that.getPartyPortfolioName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeId, _that.getTradeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.portfolio, _that.getPortfolio())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyPortfolioName != null ? this.partyPortfolioName.hashCode() : 0);
            _result = 31 * _result + (this.tradeId != null ? this.tradeId.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.portfolio != null ? this.portfolio.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PortfolioBuilder {partyPortfolioName=" + String.valueOf(this.partyPortfolioName) + ", tradeId=" + String.valueOf(this.tradeId) + ", partyTradeIdentifier=" + String.valueOf(this.partyTradeIdentifier) + ", portfolio=" + String.valueOf(this.portfolio) + ", id=" + this.id + "}";
        }
    }

    public static interface PortfolioBuilder
    extends Portfolio,
    RosettaModelObjectBuilder {
        public PartyPortfolioName.PartyPortfolioNameBuilder getOrCreatePartyPortfolioName();

        @Override
        public PartyPortfolioName.PartyPortfolioNameBuilder getPartyPortfolioName();

        public TradeId.TradeIdBuilder getOrCreateTradeId(int var1);

        public List<? extends TradeId.TradeIdBuilder> getTradeId();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getPartyTradeIdentifier();

        public PortfolioBuilder getOrCreatePortfolio(int var1);

        public List<? extends PortfolioBuilder> getPortfolio();

        public PortfolioBuilder setPartyPortfolioName(PartyPortfolioName var1);

        public PortfolioBuilder addTradeId(TradeId var1);

        public PortfolioBuilder addTradeId(TradeId var1, int var2);

        public PortfolioBuilder addTradeId(List<? extends TradeId> var1);

        public PortfolioBuilder setTradeId(List<? extends TradeId> var1);

        public PortfolioBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1);

        public PortfolioBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public PortfolioBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public PortfolioBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public PortfolioBuilder addPortfolio(Portfolio var1);

        public PortfolioBuilder addPortfolio(Portfolio var1, int var2);

        public PortfolioBuilder addPortfolio(List<? extends Portfolio> var1);

        public PortfolioBuilder setPortfolio(List<? extends Portfolio> var1);

        public PortfolioBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyPortfolioName"), processor, PartyPortfolioName.PartyPortfolioNameBuilder.class, this.getPartyPortfolioName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeId"), processor, TradeId.TradeIdBuilder.class, this.getTradeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolio"), processor, PortfolioBuilder.class, this.getPortfolio(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PortfolioBuilder prune();
    }

    public static class PortfolioImpl
    implements Portfolio {
        private final PartyPortfolioName partyPortfolioName;
        private final List<? extends TradeId> tradeId;
        private final List<? extends PartyTradeIdentifier> partyTradeIdentifier;
        private final List<? extends Portfolio> portfolio;
        private final String id;

        protected PortfolioImpl(PortfolioBuilder builder) {
            this.partyPortfolioName = Optional.ofNullable(builder.getPartyPortfolioName()).map(f -> f.build()).orElse(null);
            this.tradeId = Optional.ofNullable(builder.getTradeId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyTradeIdentifier = Optional.ofNullable(builder.getPartyTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.portfolio = Optional.ofNullable(builder.getPortfolio()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="partyPortfolioName")
        @RuneAttribute(value="partyPortfolioName")
        public PartyPortfolioName getPartyPortfolioName() {
            return this.partyPortfolioName;
        }

        @Override
        @RosettaAttribute(value="tradeId")
        @RuneAttribute(value="tradeId")
        public List<? extends TradeId> getTradeId() {
            return this.tradeId;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier")
        @RuneAttribute(value="partyTradeIdentifier")
        public List<? extends PartyTradeIdentifier> getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="portfolio")
        @RuneAttribute(value="portfolio")
        public List<? extends Portfolio> getPortfolio() {
            return this.portfolio;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public Portfolio build() {
            return this;
        }

        @Override
        public PortfolioBuilder toBuilder() {
            PortfolioBuilder builder = Portfolio.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PortfolioBuilder builder) {
            Optional.ofNullable(this.getPartyPortfolioName()).ifPresent(builder::setPartyPortfolioName);
            Optional.ofNullable(this.getTradeId()).ifPresent(builder::setTradeId);
            Optional.ofNullable(this.getPartyTradeIdentifier()).ifPresent(builder::setPartyTradeIdentifier);
            Optional.ofNullable(this.getPortfolio()).ifPresent(builder::setPortfolio);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Portfolio _that = this.getType().cast(o);
            if (!Objects.equals(this.partyPortfolioName, _that.getPartyPortfolioName())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeId, _that.getTradeId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.portfolio, _that.getPortfolio())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyPortfolioName != null ? this.partyPortfolioName.hashCode() : 0);
            _result = 31 * _result + (this.tradeId != null ? this.tradeId.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.portfolio != null ? this.portfolio.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Portfolio {partyPortfolioName=" + String.valueOf(this.partyPortfolioName) + ", tradeId=" + String.valueOf(this.tradeId) + ", partyTradeIdentifier=" + String.valueOf(this.partyTradeIdentifier) + ", portfolio=" + String.valueOf(this.portfolio) + ", id=" + this.id + "}";
        }
    }
}

