/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.TimezoneLocation;
import fpml.consolidated.shared.meta.TimeZoneMeta;
import java.time.LocalTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="TimeZone", builder=TimeZoneBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TimeZone", model="fpml", builder=TimeZoneBuilderImpl.class, version="1.2.2")
public interface TimeZone
extends RosettaModelObject {
    public static final TimeZoneMeta metaData = new TimeZoneMeta();

    public LocalTime getTime();

    public TimezoneLocation getLocation();

    public TimeZone build();

    public TimeZoneBuilder toBuilder();

    public static TimeZoneBuilder builder() {
        return new TimeZoneBuilderImpl();
    }

    default public RosettaMetaData<? extends TimeZone> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TimeZone> getType() {
        return TimeZone.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("location"), processor, TimezoneLocation.class, this.getLocation(), new AttributeMeta[0]);
    }

    public static class TimeZoneBuilderImpl
    implements TimeZoneBuilder {
        protected LocalTime time;
        protected TimezoneLocation.TimezoneLocationBuilder location;

        @Override
        @RosettaAttribute(value="time", isRequired=true)
        @RuneAttribute(value="time", isRequired=true)
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public TimezoneLocation.TimezoneLocationBuilder getLocation() {
            return this.location;
        }

        @Override
        public TimezoneLocation.TimezoneLocationBuilder getOrCreateLocation() {
            TimezoneLocation.TimezoneLocationBuilder result = this.location != null ? this.location : (this.location = TimezoneLocation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="time", isRequired=true)
        @RuneAttribute(value="time", isRequired=true)
        public TimeZoneBuilder setTime(LocalTime _time) {
            this.time = _time == null ? null : _time;
            return this;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public TimeZoneBuilder setLocation(TimezoneLocation _location) {
            this.location = _location == null ? null : _location.toBuilder();
            return this;
        }

        @Override
        public TimeZone build() {
            return new TimeZoneImpl(this);
        }

        @Override
        public TimeZoneBuilder toBuilder() {
            return this;
        }

        @Override
        public TimeZoneBuilder prune() {
            if (this.location != null && !this.location.prune().hasData()) {
                this.location = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTime() != null) {
                return true;
            }
            return this.getLocation() != null && this.getLocation().hasData();
        }

        public TimeZoneBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TimeZoneBuilder o = (TimeZoneBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLocation(), (RosettaModelObjectBuilder)o.getLocation(), this::setLocation);
            merger.mergeBasic((Object)this.getTime(), (Object)o.getTime(), this::setTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TimeZone _that = this.getType().cast(o);
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            return Objects.equals(this.location, _that.getLocation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TimeZoneBuilder {time=" + String.valueOf(this.time) + ", location=" + String.valueOf(this.location) + "}";
        }
    }

    public static interface TimeZoneBuilder
    extends TimeZone,
    RosettaModelObjectBuilder {
        public TimezoneLocation.TimezoneLocationBuilder getOrCreateLocation();

        @Override
        public TimezoneLocation.TimezoneLocationBuilder getLocation();

        public TimeZoneBuilder setTime(LocalTime var1);

        public TimeZoneBuilder setLocation(TimezoneLocation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("time"), LocalTime.class, (Object)this.getTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("location"), processor, TimezoneLocation.TimezoneLocationBuilder.class, this.getLocation(), new AttributeMeta[0]);
        }

        public TimeZoneBuilder prune();
    }

    public static class TimeZoneImpl
    implements TimeZone {
        private final LocalTime time;
        private final TimezoneLocation location;

        protected TimeZoneImpl(TimeZoneBuilder builder) {
            this.time = builder.getTime();
            this.location = Optional.ofNullable(builder.getLocation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="time", isRequired=true)
        @RuneAttribute(value="time", isRequired=true)
        public LocalTime getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public TimezoneLocation getLocation() {
            return this.location;
        }

        @Override
        public TimeZone build() {
            return this;
        }

        @Override
        public TimeZoneBuilder toBuilder() {
            TimeZoneBuilder builder = TimeZone.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TimeZoneBuilder builder) {
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
            Optional.ofNullable(this.getLocation()).ifPresent(builder::setLocation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TimeZone _that = this.getType().cast(o);
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            return Objects.equals(this.location, _that.getLocation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TimeZone {time=" + String.valueOf(this.time) + ", location=" + String.valueOf(this.location) + "}";
        }
    }
}

