/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.ProductId;
import fpml.consolidated.shared.ProductType;
import fpml.consolidated.shared.meta.ProductModelSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ProductModelSequence", builder=ProductModelSequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ProductModelSequence", model="fpml", builder=ProductModelSequenceBuilderImpl.class, version="1.2.2")
public interface ProductModelSequence
extends RosettaModelObject {
    public static final ProductModelSequenceMeta metaData = new ProductModelSequenceMeta();

    public List<? extends ProductType> getProductType();

    public List<? extends ProductId> getProductId();

    public ProductModelSequence build();

    public ProductModelSequenceBuilder toBuilder();

    public static ProductModelSequenceBuilder builder() {
        return new ProductModelSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends ProductModelSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ProductModelSequence> getType() {
        return ProductModelSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productType"), processor, ProductType.class, this.getProductType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productId"), processor, ProductId.class, this.getProductId(), new AttributeMeta[0]);
    }

    public static class ProductModelSequenceBuilderImpl
    implements ProductModelSequenceBuilder {
        protected List<ProductType.ProductTypeBuilder> productType = new ArrayList<ProductType.ProductTypeBuilder>();
        protected List<ProductId.ProductIdBuilder> productId = new ArrayList<ProductId.ProductIdBuilder>();

        @Override
        @RosettaAttribute(value="productType", isRequired=true)
        @RuneAttribute(value="productType", isRequired=true)
        public List<? extends ProductType.ProductTypeBuilder> getProductType() {
            return this.productType;
        }

        @Override
        public ProductType.ProductTypeBuilder getOrCreateProductType(int index) {
            if (this.productType == null) {
                this.productType = new ArrayList<ProductType.ProductTypeBuilder>();
            }
            return (ProductType.ProductTypeBuilder)this.getIndex(this.productType, index, () -> {
                ProductType.ProductTypeBuilder newProductType = ProductType.builder();
                return newProductType;
            });
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public List<? extends ProductId.ProductIdBuilder> getProductId() {
            return this.productId;
        }

        @Override
        public ProductId.ProductIdBuilder getOrCreateProductId(int index) {
            if (this.productId == null) {
                this.productId = new ArrayList<ProductId.ProductIdBuilder>();
            }
            return (ProductId.ProductIdBuilder)this.getIndex(this.productId, index, () -> {
                ProductId.ProductIdBuilder newProductId = ProductId.builder();
                return newProductId;
            });
        }

        @Override
        @RosettaAttribute(value="productType", isRequired=true)
        @RuneAttribute(value="productType", isRequired=true)
        public ProductModelSequenceBuilder addProductType(ProductType _productType) {
            if (_productType != null) {
                this.productType.add(_productType.toBuilder());
            }
            return this;
        }

        @Override
        public ProductModelSequenceBuilder addProductType(ProductType _productType, int idx) {
            this.getIndex(this.productType, idx, () -> _productType.toBuilder());
            return this;
        }

        @Override
        public ProductModelSequenceBuilder addProductType(List<? extends ProductType> productTypes) {
            if (productTypes != null) {
                for (ProductType productType : productTypes) {
                    this.productType.add(productType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productType")
        public ProductModelSequenceBuilder setProductType(List<? extends ProductType> productTypes) {
            this.productType = productTypes == null ? new ArrayList<ProductType.ProductTypeBuilder>() : (List)productTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public ProductModelSequenceBuilder addProductId(ProductId _productId) {
            if (_productId != null) {
                this.productId.add(_productId.toBuilder());
            }
            return this;
        }

        @Override
        public ProductModelSequenceBuilder addProductId(ProductId _productId, int idx) {
            this.getIndex(this.productId, idx, () -> _productId.toBuilder());
            return this;
        }

        @Override
        public ProductModelSequenceBuilder addProductId(List<? extends ProductId> productIds) {
            if (productIds != null) {
                for (ProductId productId : productIds) {
                    this.productId.add(productId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productId")
        public ProductModelSequenceBuilder setProductId(List<? extends ProductId> productIds) {
            this.productId = productIds == null ? new ArrayList<ProductId.ProductIdBuilder>() : (List)productIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ProductModelSequence build() {
            return new ProductModelSequenceImpl(this);
        }

        @Override
        public ProductModelSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public ProductModelSequenceBuilder prune() {
            this.productType = this.productType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.productId = this.productId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getProductType() != null && this.getProductType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getProductId() != null && this.getProductId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ProductModelSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ProductModelSequenceBuilder o = (ProductModelSequenceBuilder)other;
            merger.mergeRosetta(this.getProductType(), o.getProductType(), this::getOrCreateProductType);
            merger.mergeRosetta(this.getProductId(), o.getProductId(), this::getOrCreateProductId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductModelSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.productType, _that.getProductType())) {
                return false;
            }
            return ListEquals.listEquals(this.productId, _that.getProductId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.productType != null ? this.productType.hashCode() : 0);
            _result = 31 * _result + (this.productId != null ? this.productId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductModelSequenceBuilder {productType=" + String.valueOf(this.productType) + ", productId=" + String.valueOf(this.productId) + "}";
        }
    }

    public static interface ProductModelSequenceBuilder
    extends ProductModelSequence,
    RosettaModelObjectBuilder {
        public ProductType.ProductTypeBuilder getOrCreateProductType(int var1);

        public List<? extends ProductType.ProductTypeBuilder> getProductType();

        public ProductId.ProductIdBuilder getOrCreateProductId(int var1);

        public List<? extends ProductId.ProductIdBuilder> getProductId();

        public ProductModelSequenceBuilder addProductType(ProductType var1);

        public ProductModelSequenceBuilder addProductType(ProductType var1, int var2);

        public ProductModelSequenceBuilder addProductType(List<? extends ProductType> var1);

        public ProductModelSequenceBuilder setProductType(List<? extends ProductType> var1);

        public ProductModelSequenceBuilder addProductId(ProductId var1);

        public ProductModelSequenceBuilder addProductId(ProductId var1, int var2);

        public ProductModelSequenceBuilder addProductId(List<? extends ProductId> var1);

        public ProductModelSequenceBuilder setProductId(List<? extends ProductId> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productType"), processor, ProductType.ProductTypeBuilder.class, this.getProductType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productId"), processor, ProductId.ProductIdBuilder.class, this.getProductId(), new AttributeMeta[0]);
        }

        public ProductModelSequenceBuilder prune();
    }

    public static class ProductModelSequenceImpl
    implements ProductModelSequence {
        private final List<? extends ProductType> productType;
        private final List<? extends ProductId> productId;

        protected ProductModelSequenceImpl(ProductModelSequenceBuilder builder) {
            this.productType = Optional.ofNullable(builder.getProductType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.productId = Optional.ofNullable(builder.getProductId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="productType", isRequired=true)
        @RuneAttribute(value="productType", isRequired=true)
        public List<? extends ProductType> getProductType() {
            return this.productType;
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public List<? extends ProductId> getProductId() {
            return this.productId;
        }

        @Override
        public ProductModelSequence build() {
            return this;
        }

        @Override
        public ProductModelSequenceBuilder toBuilder() {
            ProductModelSequenceBuilder builder = ProductModelSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProductModelSequenceBuilder builder) {
            Optional.ofNullable(this.getProductType()).ifPresent(builder::setProductType);
            Optional.ofNullable(this.getProductId()).ifPresent(builder::setProductId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductModelSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.productType, _that.getProductType())) {
                return false;
            }
            return ListEquals.listEquals(this.productId, _that.getProductId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.productType != null ? this.productType.hashCode() : 0);
            _result = 31 * _result + (this.productId != null ? this.productId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductModelSequence {productType=" + String.valueOf(this.productType) + ", productId=" + String.valueOf(this.productId) + "}";
        }
    }
}

