/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.meta.CashflowNotionalMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CashflowNotional", builder=CashflowNotionalBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CashflowNotional", model="fpml", builder=CashflowNotionalBuilderImpl.class, version="1.2.2")
public interface CashflowNotional
extends RosettaModelObject {
    public static final CashflowNotionalMeta metaData = new CashflowNotionalMeta();

    public Currency getCurrency();

    public String getUnits();

    public BigDecimal getAmount();

    public String getId();

    public CashflowNotional build();

    public CashflowNotionalBuilder toBuilder();

    public static CashflowNotionalBuilder builder() {
        return new CashflowNotionalBuilderImpl();
    }

    default public RosettaMetaData<? extends CashflowNotional> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CashflowNotional> getType() {
        return CashflowNotional.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("units"), String.class, (Object)this.getUnits(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CashflowNotionalBuilderImpl
    implements CashflowNotionalBuilder {
        protected Currency.CurrencyBuilder currency;
        protected String units;
        protected BigDecimal amount;
        protected String id;

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="units")
        @RuneAttribute(value="units")
        public String getUnits() {
            return this.units;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public CashflowNotionalBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="units")
        @RuneAttribute(value="units")
        public CashflowNotionalBuilder setUnits(String _units) {
            this.units = _units == null ? null : _units;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public CashflowNotionalBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CashflowNotionalBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public CashflowNotional build() {
            return new CashflowNotionalImpl(this);
        }

        @Override
        public CashflowNotionalBuilder toBuilder() {
            return this;
        }

        @Override
        public CashflowNotionalBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getUnits() != null) {
                return true;
            }
            if (this.getAmount() != null) {
                return true;
            }
            return this.getId() != null;
        }

        public CashflowNotionalBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashflowNotionalBuilder o = (CashflowNotionalBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeBasic((Object)this.getUnits(), (Object)o.getUnits(), this::setUnits, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashflowNotional _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.units, _that.getUnits())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.units != null ? this.units.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowNotionalBuilder {currency=" + String.valueOf(this.currency) + ", units=" + this.units + ", amount=" + String.valueOf(this.amount) + ", id=" + this.id + "}";
        }
    }

    public static interface CashflowNotionalBuilder
    extends CashflowNotional,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public CashflowNotionalBuilder setCurrency(Currency var1);

        public CashflowNotionalBuilder setUnits(String var1);

        public CashflowNotionalBuilder setAmount(BigDecimal var1);

        public CashflowNotionalBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("units"), String.class, (Object)this.getUnits(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CashflowNotionalBuilder prune();
    }

    public static class CashflowNotionalImpl
    implements CashflowNotional {
        private final Currency currency;
        private final String units;
        private final BigDecimal amount;
        private final String id;

        protected CashflowNotionalImpl(CashflowNotionalBuilder builder) {
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.units = builder.getUnits();
            this.amount = builder.getAmount();
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="units")
        @RuneAttribute(value="units")
        public String getUnits() {
            return this.units;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public CashflowNotional build() {
            return this;
        }

        @Override
        public CashflowNotionalBuilder toBuilder() {
            CashflowNotionalBuilder builder = CashflowNotional.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashflowNotionalBuilder builder) {
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getUnits()).ifPresent(builder::setUnits);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashflowNotional _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.units, _that.getUnits())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.units != null ? this.units.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowNotional {currency=" + String.valueOf(this.currency) + ", units=" + this.units + ", amount=" + String.valueOf(this.amount) + ", id=" + this.id + "}";
        }
    }
}

