/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.riskdef.InstrumentSetSequence;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InstrumentSetSequenceChoice")
@ImplementedBy(value=Default.class)
public interface InstrumentSetSequenceChoice
extends Validator<InstrumentSetSequence> {
    public static final String NAME = "InstrumentSetSequenceChoice";
    public static final String DEFINITION = "optional choice underlyingAsset, curveInstrument";

    public static class NoOp
    implements InstrumentSetSequenceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InstrumentSetSequence instrumentSetSequence) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InstrumentSetSequenceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InstrumentSetSequence instrumentSetSequence) {
            ComparisonResult result = this.executeDataRule(instrumentSetSequence);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InstrumentSetSequenceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InstrumentSetSequence", (RosettaPath)path, (String)InstrumentSetSequenceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InstrumentSetSequenceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InstrumentSetSequence", (RosettaPath)path, (String)InstrumentSetSequenceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(InstrumentSetSequence instrumentSetSequence) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)instrumentSetSequence), Arrays.asList("underlyingAsset", "curveInstrument"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

