/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.riskdef.BasicAssetValuation;
import fpml.consolidated.riskdef.InstrumentSet;
import fpml.consolidated.riskdef.meta.QuotedAssetSetMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="QuotedAssetSet", builder=QuotedAssetSetBuilderImpl.class, version="1.2.2")
@RuneDataType(value="QuotedAssetSet", model="fpml", builder=QuotedAssetSetBuilderImpl.class, version="1.2.2")
public interface QuotedAssetSet
extends RosettaModelObject {
    public static final QuotedAssetSetMeta metaData = new QuotedAssetSetMeta();

    public InstrumentSet getInstrumentSet();

    public List<? extends BasicAssetValuation> getAssetQuote();

    public QuotedAssetSet build();

    public QuotedAssetSetBuilder toBuilder();

    public static QuotedAssetSetBuilder builder() {
        return new QuotedAssetSetBuilderImpl();
    }

    default public RosettaMetaData<? extends QuotedAssetSet> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends QuotedAssetSet> getType() {
        return QuotedAssetSet.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("instrumentSet"), processor, InstrumentSet.class, this.getInstrumentSet(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetQuote"), processor, BasicAssetValuation.class, this.getAssetQuote(), new AttributeMeta[0]);
    }

    public static class QuotedAssetSetBuilderImpl
    implements QuotedAssetSetBuilder {
        protected InstrumentSet.InstrumentSetBuilder instrumentSet;
        protected List<BasicAssetValuation.BasicAssetValuationBuilder> assetQuote = new ArrayList<BasicAssetValuation.BasicAssetValuationBuilder>();

        @Override
        @RosettaAttribute(value="instrumentSet")
        @RuneAttribute(value="instrumentSet")
        public InstrumentSet.InstrumentSetBuilder getInstrumentSet() {
            return this.instrumentSet;
        }

        @Override
        public InstrumentSet.InstrumentSetBuilder getOrCreateInstrumentSet() {
            InstrumentSet.InstrumentSetBuilder result = this.instrumentSet != null ? this.instrumentSet : (this.instrumentSet = InstrumentSet.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetQuote")
        @RuneAttribute(value="assetQuote")
        public List<? extends BasicAssetValuation.BasicAssetValuationBuilder> getAssetQuote() {
            return this.assetQuote;
        }

        @Override
        public BasicAssetValuation.BasicAssetValuationBuilder getOrCreateAssetQuote(int index) {
            if (this.assetQuote == null) {
                this.assetQuote = new ArrayList<BasicAssetValuation.BasicAssetValuationBuilder>();
            }
            return (BasicAssetValuation.BasicAssetValuationBuilder)this.getIndex(this.assetQuote, index, () -> {
                BasicAssetValuation.BasicAssetValuationBuilder newAssetQuote = BasicAssetValuation.builder();
                return newAssetQuote;
            });
        }

        @Override
        @RosettaAttribute(value="instrumentSet")
        @RuneAttribute(value="instrumentSet")
        public QuotedAssetSetBuilder setInstrumentSet(InstrumentSet _instrumentSet) {
            this.instrumentSet = _instrumentSet == null ? null : _instrumentSet.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetQuote")
        @RuneAttribute(value="assetQuote")
        public QuotedAssetSetBuilder addAssetQuote(BasicAssetValuation _assetQuote) {
            if (_assetQuote != null) {
                this.assetQuote.add(_assetQuote.toBuilder());
            }
            return this;
        }

        @Override
        public QuotedAssetSetBuilder addAssetQuote(BasicAssetValuation _assetQuote, int idx) {
            this.getIndex(this.assetQuote, idx, () -> _assetQuote.toBuilder());
            return this;
        }

        @Override
        public QuotedAssetSetBuilder addAssetQuote(List<? extends BasicAssetValuation> assetQuotes) {
            if (assetQuotes != null) {
                for (BasicAssetValuation basicAssetValuation : assetQuotes) {
                    this.assetQuote.add(basicAssetValuation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="assetQuote")
        public QuotedAssetSetBuilder setAssetQuote(List<? extends BasicAssetValuation> assetQuotes) {
            this.assetQuote = assetQuotes == null ? new ArrayList<BasicAssetValuation.BasicAssetValuationBuilder>() : (List)assetQuotes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public QuotedAssetSet build() {
            return new QuotedAssetSetImpl(this);
        }

        @Override
        public QuotedAssetSetBuilder toBuilder() {
            return this;
        }

        @Override
        public QuotedAssetSetBuilder prune() {
            if (this.instrumentSet != null && !this.instrumentSet.prune().hasData()) {
                this.instrumentSet = null;
            }
            this.assetQuote = this.assetQuote.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getInstrumentSet() != null && this.getInstrumentSet().hasData()) {
                return true;
            }
            return this.getAssetQuote() != null && this.getAssetQuote().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public QuotedAssetSetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            QuotedAssetSetBuilder o = (QuotedAssetSetBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInstrumentSet(), (RosettaModelObjectBuilder)o.getInstrumentSet(), this::setInstrumentSet);
            merger.mergeRosetta(this.getAssetQuote(), o.getAssetQuote(), this::getOrCreateAssetQuote);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            QuotedAssetSet _that = this.getType().cast(o);
            if (!Objects.equals(this.instrumentSet, _that.getInstrumentSet())) {
                return false;
            }
            return ListEquals.listEquals(this.assetQuote, _that.getAssetQuote());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.instrumentSet != null ? this.instrumentSet.hashCode() : 0);
            _result = 31 * _result + (this.assetQuote != null ? this.assetQuote.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuotedAssetSetBuilder {instrumentSet=" + String.valueOf(this.instrumentSet) + ", assetQuote=" + String.valueOf(this.assetQuote) + "}";
        }
    }

    public static interface QuotedAssetSetBuilder
    extends QuotedAssetSet,
    RosettaModelObjectBuilder {
        public InstrumentSet.InstrumentSetBuilder getOrCreateInstrumentSet();

        @Override
        public InstrumentSet.InstrumentSetBuilder getInstrumentSet();

        public BasicAssetValuation.BasicAssetValuationBuilder getOrCreateAssetQuote(int var1);

        public List<? extends BasicAssetValuation.BasicAssetValuationBuilder> getAssetQuote();

        public QuotedAssetSetBuilder setInstrumentSet(InstrumentSet var1);

        public QuotedAssetSetBuilder addAssetQuote(BasicAssetValuation var1);

        public QuotedAssetSetBuilder addAssetQuote(BasicAssetValuation var1, int var2);

        public QuotedAssetSetBuilder addAssetQuote(List<? extends BasicAssetValuation> var1);

        public QuotedAssetSetBuilder setAssetQuote(List<? extends BasicAssetValuation> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("instrumentSet"), processor, InstrumentSet.InstrumentSetBuilder.class, this.getInstrumentSet(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetQuote"), processor, BasicAssetValuation.BasicAssetValuationBuilder.class, this.getAssetQuote(), new AttributeMeta[0]);
        }

        public QuotedAssetSetBuilder prune();
    }

    public static class QuotedAssetSetImpl
    implements QuotedAssetSet {
        private final InstrumentSet instrumentSet;
        private final List<? extends BasicAssetValuation> assetQuote;

        protected QuotedAssetSetImpl(QuotedAssetSetBuilder builder) {
            this.instrumentSet = Optional.ofNullable(builder.getInstrumentSet()).map(f -> f.build()).orElse(null);
            this.assetQuote = Optional.ofNullable(builder.getAssetQuote()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="instrumentSet")
        @RuneAttribute(value="instrumentSet")
        public InstrumentSet getInstrumentSet() {
            return this.instrumentSet;
        }

        @Override
        @RosettaAttribute(value="assetQuote")
        @RuneAttribute(value="assetQuote")
        public List<? extends BasicAssetValuation> getAssetQuote() {
            return this.assetQuote;
        }

        @Override
        public QuotedAssetSet build() {
            return this;
        }

        @Override
        public QuotedAssetSetBuilder toBuilder() {
            QuotedAssetSetBuilder builder = QuotedAssetSet.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuotedAssetSetBuilder builder) {
            Optional.ofNullable(this.getInstrumentSet()).ifPresent(builder::setInstrumentSet);
            Optional.ofNullable(this.getAssetQuote()).ifPresent(builder::setAssetQuote);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            QuotedAssetSet _that = this.getType().cast(o);
            if (!Objects.equals(this.instrumentSet, _that.getInstrumentSet())) {
                return false;
            }
            return ListEquals.listEquals(this.assetQuote, _that.getAssetQuote());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.instrumentSet != null ? this.instrumentSet.hashCode() : 0);
            _result = 31 * _result + (this.assetQuote != null ? this.assetQuote.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuotedAssetSet {instrumentSet=" + String.valueOf(this.instrumentSet) + ", assetQuote=" + String.valueOf(this.assetQuote) + "}";
        }
    }
}

